package w83b.w83bDAO;

import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

import org.apache.commons.lang.StringUtils;

import w83b.util.jdbc.W83bDataBase;
import w83b.w83bBeans.W83bDatosFasesTramitesBean;
import w83b.w83bBeans.W83bDocBean;
import w83b.w83bBeans.W83bHistorialPreavisoBean;
import w83b.w83bBeans.W83bImpugnacionesBean;
import w83b.w83bBeans.W83bPreavisosBean;
import w83b.w83bBeans.W83bTipoDocumentoBean;
import w83b.w83bBeans.W83bTramitePreavisoBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bDAO.w83bConstantesBD.W83bActasBD;
import w83b.w83bDAO.w83bConstantesBD.W83bCentroTrabajoBD;
import w83b.w83bDAO.w83bConstantesBD.W83bCentroTrabajoVistaBD;
import w83b.w83bDAO.w83bConstantesBD.W83bComprobarCentroTrabajoPreavisoVistaBD;
import w83b.w83bDAO.w83bConstantesBD.W83bImpugnacionesBD;
import w83b.w83bDAO.w83bConstantesBD.W83bPreavisosBD;
import w83b.w83bDAO.w83bConstantesBD.W83bTiposDocumentosVistaBD;
import w83b.w83bManager.W83bComunes;
import w83b.w83bManager.W83bIComunes;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bClsTrazas;
import w83b.w83bUtilidadesComunes.W83bDateUtil;
import w83b.w83bUtilidadesLibroRegistro.W83bLibroRegistro;
import w83b.w83bUtilidadesLibroRegistro.W83bLibroRegistroException;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;

public class W83bPreavisosDAO implements W83bIPreavisosDAO{

	
	public java.util.List buscarPreavisos (w83b.w83bBeans.W83bPreavisosBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT DISTINCT ");
		strSql.append(" vistaSinCentros.").append(W83bPreavisosBD.num_preaviso_completo).append(", ");
		strSql.append(" vistaSinCentros.").append(W83bPreavisosBD.cod_territorio).append(", ");
		strSql.append(" vistaSinCentros.").append(W83bPreavisosBD.anyo_eleccion).append(", ");
		strSql.append(" vistaSinCentros.").append(W83bPreavisosBD.num_preaviso).append(", ");
		strSql.append(" vistaSinCentros.").append(W83bPreavisosBD.fecha_entrada).append(", ");
		strSql.append(" vistaSinCentros.").append(W83bPreavisosBD.fecha_inicio).append(", ");
		strSql.append(" vistaSinCentros.").append(W83bPreavisosBD.fecha_eleccion).append(", ");
		strSql.append(" upper(centros.").append(W83bCentroTrabajoBD.razonSocial).append(") AS ").append(W83bPreavisosBD.razon_social).append(", ");
		strSql.append(" centros.").append(W83bCentroTrabajoBD.codigoCentro).append(" AS ").append(W83bPreavisosBD.id_centrotrabajo).append(", ");
		strSql.append(" centros.").append(W83bCentroTrabajoBD.codNifCif).append(" AS ").append(W83bPreavisosBD.cif).append(", ");
		strSql.append(" centros.").append(W83bCentroTrabajoBD.ncentroTrab).append(" AS ").append(W83bPreavisosBD.num_centro).append(", ");
		
		/*if (W83bClsConstantes.CONSTANTE_CASTELLANO.equals(param.getIdioma()))
		{
			strSql.append(" upper(centros.").append(W83bPreavisosBD.TERRITORIO).append(") AS ").append(W83bPreavisosBD.territorio).append(",");

		}
		else
		{
			strSql.append(" upper(centros.").append(W83bPreavisosBD.TERRITORIO_EUSK).append(") AS ").append(W83bPreavisosBD.territorio).append(",");
		}
		if (W83bClsConstantes.CONSTANTE_CASTELLANO.equals(param.getIdioma()))
		{
			strSql.append(" upper(centros.").append(W83bPreavisosBD.MUNICIPIO).append(") AS ").append(W83bPreavisosBD.municipio).append(",");

		}
		else
		{
			strSql.append(" upper(centros.").append(W83bPreavisosBD.MUNICIPIO).append(") AS ").append(W83bPreavisosBD.municipio).append(",");
		}*/
		strSql.append(" upper(centros.").append(W83bCentroTrabajoBD.codProvinciaCentro).append(") AS ").append(W83bPreavisosBD.territorio).append(",");
		strSql.append(" upper(centros.").append(W83bCentroTrabajoBD.codMunicipioCentro).append(") AS ").append(W83bPreavisosBD.municipio).append(",");
		if (W83bClsConstantes.CONSTANTE_CASTELLANO.equals(param.getIdioma()))
		{
			strSql.append(W83bPreavisosBD.desc_convenio).append(" AS ").append(W83bPreavisosBD.descripcion_convenio).append(",");

		}
		else
		{
			strSql.append(W83bPreavisosBD.dese_convenio).append(" AS ").append(W83bPreavisosBD.descripcion_convenio).append(",");
		}
		//strSql.append(" centros.").append(W83bPreavisosBD.NUM_TRABAJADORES).append(" AS ").append(W83bPreavisosBD.num_trabajadores).append(", ");
		strSql.append(" vistaSinCentros.").append(W83bPreavisosBD.eleccion_parcial).append(", ");
		strSql.append(" vistaSinCentros.").append(W83bPreavisosBD.preaviso_global).append(", ");
		strSql.append(" vistaSinCentros.").append(W83bPreavisosBD.cod_convenio).append(", ");
		strSql.append(" vistaSinCentros.").append(W83bPreavisosBD.admon_empresa).append(", ");
		strSql.append(" vistaSinCentros.").append(W83bPreavisosBD.num_acta).append(", ");
		strSql.append(" vistaSinCentros.").append(W83bPreavisosBD.npreavisosintcompleto).append(", ");
		strSql.append(" vistaSinCentros.").append(W83bPreavisosBD.numeroImpugnaciones).append(", ");
		
		strSql.append(" vistaSinCentros.").append(W83bPreavisosBD.num_centros_afectados).append(", ");
		
		strSql.append("'").append(param.getIdioma()).append("' as IDIOMA");
		
		strSql.append(" FROM ").append(W83bPreavisosBD.preavisosSinCentroView).append(" vistaSinCentros");
		strSql.append(" ,").append(W83bCentroTrabajoBD.tablaCTDesa).append(" centros");
		
		boolean where = false;
		
		strSql.append(" WHERE centros.").append(W83bCentroTrabajoBD.codigoCentro);
		strSql.append("(+)= ").append(" vistaSinCentros.").append(W83bPreavisosBD.id_centrotrabajo);
		
		
		
		if(StringUtils.isNotEmpty(param.getCodTerritorioDesde())){
			
			strSql.append(" AND ");
			where = true;
			strSql.append(" ").append(" vistaSinCentros.").append(W83bPreavisosBD.cod_territorio).append(" = ?");
			params.add(Integer.valueOf(param.getCodTerritorioDesde()));
		}else{
		
			strSql.append(" AND ");
			where = true;
			strSql.append(" ").append(" (vistaSinCentros.").append(W83bPreavisosBD.cod_territorio).append(" = ?");
			strSql.append(" OR ").append(" vistaSinCentros.").append(W83bPreavisosBD.cod_territorio).append(" = ?");
			strSql.append(" OR ").append(" vistaSinCentros.").append(W83bPreavisosBD.cod_territorio).append(" = ?)");
			
			params.add(W83bClsConstantes.CONSTANTE_ALAVA);
			params.add(W83bClsConstantes.CONSTANTE_BIZKAIA);
			params.add(W83bClsConstantes.CONSTANTE_GIPUZKOA);
			
		}

		String desde = param.getAnyoDesde();
		String hasta = param.getAnyoHasta();
		String numDesde = param.getNumpreaviso_desde();
		String numHasta = param.getNumpreaviso_hasta();
		if(StringUtils.isEmpty(param.getAnyoDesde())){
			desde = "0000";
		}
		if(StringUtils.isEmpty(param.getAnyoHasta())){
			hasta = "9999";
		}
		if(StringUtils.isEmpty(param.getNumpreaviso_desde())){
			numDesde = "000000";
		}else if(6>param.getNumpreaviso_desde().length()){
			for(int i = param.getNumpreaviso_desde().length(),size = 6;i<size;i++){
				numDesde = "0"+numDesde;//NOPMD
			}
		}
		if(StringUtils.isEmpty(param.getNumpreaviso_hasta())){
			numHasta = "999999";
		}else if(6>param.getNumpreaviso_hasta().length()){
			for(int i = param.getNumpreaviso_hasta().length(),size = 6;i<size;i++){
				numHasta = "0"+numHasta;//NOPMD
			}
		}
		desde = desde + numDesde;//NOPMD
		hasta = hasta + numHasta;//NOPMD
		if(!where){
			strSql.append(" WHERE ");
			where = true;
		}else{
			strSql.append(" AND ");				
		}
		where = true;
		strSql.append(" vistaSinCentros.").append(W83bPreavisosBD.npreavisosint).append(" >= ?");
		params.add(BigDecimal.valueOf(Long.parseLong(desde)));
		strSql.append(" AND ");				
		strSql.append(" vistaSinCentros.").append(W83bPreavisosBD.npreavisosint).append(" <= ?");
		params.add(BigDecimal.valueOf(Long.parseLong(hasta)));
		
		if(StringUtils.isNotEmpty(param.getCentroTrabajo().getCifnif())){
			if(!where){
				strSql.append(" WHERE ");
				where = true;
			}else{
				strSql.append(" AND ");				
			}
			strSql.append("centros.").append(W83bCentroTrabajoBD.codNifCif).append(" = ?");
			params.add(param.getCentroTrabajo().getCifnif().toUpperCase());
		}
		if(StringUtils.isNotEmpty(param.getCentroTrabajo().getRazonSocial())){
			if(!where){
				strSql.append(" WHERE ");
				where = true;
			}else{
				strSql.append(" AND ");				
			}
			strSql.append("(UPPER(centros.").append(W83bCentroTrabajoBD.razonSocial).append(") like ?");
			params.add("%"+param.getCentroTrabajo().getRazonSocial().toUpperCase()+"%");
			strSql.append(" or UPPER(centros.").append(W83bCentroTrabajoBD.razonSocialSCaractControl).append(") like ?)");
			params.add("%"+param.getCentroTrabajo().getRazonSocial().toUpperCase()+"%");
		}
		if(StringUtils.isNotEmpty(param.getCentroTrabajo().getCodTerritorio())){
			if(!where){
				strSql.append(" WHERE ");
				where = true;
			}else{
				strSql.append(" AND ");				
			}
			strSql.append("centros.").append(W83bCentroTrabajoBD.codProvinciaCentro).append(" = ?");
			params.add(new Integer(param.getCentroTrabajo().getCodTerritorio()));
		}
		if(StringUtils.isNotEmpty(param.getCentroTrabajo().getCodMunicipio())){
			if(!where){
				strSql.append(" WHERE ");
				where = true;
			}else{
				strSql.append(" AND ");				
			}
			strSql.append(" centros.").append(W83bCentroTrabajoBD.codMunicipioCentro).append(" = ?");
			params.add(new Integer(param.getCentroTrabajo().getCodMunicipio()));
		}
		//Numero de trabajadores
		if(StringUtils.isNotEmpty(param.getDesdeT())){
			if(!where){
				strSql.append(" WHERE ");
				where = true;
			}else{
				strSql.append(" AND ");				
			}
			strSql.append(" vistaSinCentros.").append(W83bPreavisosBD.NUM_TRABAJADORES).append(" >= ?");
			params.add(new Integer(param.getDesdeT()));
		}
		if(StringUtils.isNotEmpty(param.getHastaT())){
			if(!where){
				strSql.append(" WHERE ");
				where = true;
			}else{
				strSql.append(" AND ");				
			}
			strSql.append(" vistaSinCentros.").append(W83bPreavisosBD.NUM_TRABAJADORES).append(" <= ?");
			params.add(new Integer(param.getHastaT()));
		}
		if(StringUtils.isNotEmpty(param.getFecha_entrada_desde())){
			if(!where){
				strSql.append(" WHERE ");
				where = true;
			}else{
				strSql.append(" AND ");				
			}
			strSql.append(" vistaSinCentros.").append(W83bPreavisosBD.fecha_entrada).append(" >= to_date(?,?)");
			params.add(param.getFecha_entrada_desde());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}
		if(StringUtils.isNotEmpty(param.getFecha_entrada_hasta())){
			if(!where){
				strSql.append(" WHERE ");
				where = true;
			}else{
				strSql.append(" AND ");				
			}
			strSql.append(" vistaSinCentros.").append(W83bPreavisosBD.fecha_entrada).append(" <= to_date(?,?)");
			params.add(param.getFecha_entrada_hasta());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}
		if(StringUtils.isNotEmpty(param.getFecha_eleccion_desde())){
			if(!where){
				strSql.append(" WHERE ");
				where = true;
			}else{
				strSql.append(" AND ");				
			}
			strSql.append(" vistaSinCentros.").append(W83bPreavisosBD.fecha_eleccion).append(" >= to_date(?,?)");
			params.add(param.getFecha_eleccion_desde());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}
		if(StringUtils.isNotEmpty(param.getFecha_eleccion_hasta())){
			if(!where){
				strSql.append(" WHERE ");
				where = true;
			}else{
				strSql.append(" AND ");				
			}
			strSql.append(" vistaSinCentros.").append(W83bPreavisosBD.fecha_eleccion).append(" <= to_date(?,?)");
			params.add(param.getFecha_eleccion_hasta());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}
		if(StringUtils.isNotEmpty(param.getSinfechaeleccion())){
			if(!where){
				strSql.append(" WHERE ");
				where = true;
			}else{
				strSql.append(" AND ");				
			}
			strSql.append(W83bPreavisosBD.fecha_eleccion).append(" IS NULL");
		}
		if(StringUtils.isNotEmpty(param.getFecha_inicio_desde())){
			if(!where){
				strSql.append(" WHERE ");
				where = true;
			}else{
				strSql.append(" AND ");				
			}
			strSql.append(" vistaSinCentros.").append(W83bPreavisosBD.fecha_inicio).append(" >= to_date(?,?)");
			params.add(param.getFecha_inicio_desde());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}
		if(StringUtils.isNotEmpty(param.getFecha_inicio_hasta())){
			if(!where){
				strSql.append(" WHERE ");
				where = true;
			}else{
				strSql.append(" AND ");				
			}
			strSql.append(" vistaSinCentros.").append(W83bPreavisosBD.fecha_inicio).append(" <= to_date(?,?)");
			params.add(param.getFecha_inicio_hasta());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}
		
		if(StringUtils.isNotEmpty(param.getEleccion_parcial())
				||StringUtils.isNotEmpty(param.getPreaviso_global())){
			if(!where){
				strSql.append(" WHERE (");
				where = true;
			}else{
				strSql.append(" AND (");				
			}
			boolean whereOR = false;
			if(StringUtils.isNotEmpty(param.getEleccion_parcial())){
				strSql.append(" vistaSinCentros.").append(W83bPreavisosBD.eleccion_parcial).append(" = ?");
				params.add(param.getEleccion_parcial());
				whereOR = true;
			}
			if(StringUtils.isNotEmpty(param.getPreaviso_global())){
				if(whereOR){				
					strSql.append(" OR ");				
				}
				strSql.append(" vistaSinCentros.").append(W83bPreavisosBD.preaviso_global).append(" = ?");
				params.add(param.getPreaviso_global());
			}
			strSql.append(") ");			
		}
		
		
		if(StringUtils.isNotEmpty(param.getFecha_tramite_desde())){
			if(!where){
				strSql.append(" WHERE ");
				where = true;
			}else{
				strSql.append(" AND ( ");				
			}
			strSql.append(" vistaSinCentros.").append(W83bPreavisosBD.f_actu_tramite).append(" >= to_date(?,?)");
			params.add(param.getFecha_tramite_desde());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}
		if(StringUtils.isNotEmpty(param.getFecha_tramite_hasta())){
			if(!where){
				strSql.append(" WHERE ");
				where = true;
			}else{
				strSql.append(" OR ");				
			}
			strSql.append(" vistaSinCentros.").append(W83bPreavisosBD.f_actu_tramite).append(" <= to_date(?,?)");
			params.add(param.getFecha_tramite_hasta());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}
		if(StringUtils.isNotEmpty(param.getFecha_tramite_desde())){
			if(!where){
				strSql.append(" WHERE ");
				where = true;
			}else{
				strSql.append(" OR ");				
			}
			strSql.append(" vistaSinCentros.").append(W83bPreavisosBD.f_modif_tramite).append(" >= to_date(?,?)");
			params.add(param.getFecha_tramite_desde());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}
		if(StringUtils.isNotEmpty(param.getFecha_tramite_hasta())){
			if(!where){
				strSql.append(" WHERE ");
				where = true;
			}else{
				strSql.append(" OR ");				
			}
			strSql.append(" vistaSinCentros.").append(W83bPreavisosBD.f_modif_tramite).append(" <= to_date(?,?)");
			strSql.append(" ) ");
			params.add(param.getFecha_tramite_hasta());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}
		
		if(StringUtils.isNotEmpty(param.getCodTramite())){
			if (!StringUtils.isNotEmpty(param.getUtramite()))
			{
				//no viene con utramite
				if(!where){
					strSql.append(" WHERE ");
					where = true;
				}else{
					strSql.append(" AND ");				
				}
				strSql.append(" vistaSinCentros.").append(W83bPreavisosBD.cod_tramite).append(" = ?");
				params.add(param.getCodTramite());
			}
			else
			{
				//hay que agrupar y luego hacer un having
				strSql.append(" GROUP BY ");
				strSql.append(" vistaSinCentros.").append(W83bPreavisosBD.num_preaviso_completo).append(", ");
				strSql.append(" vistaSinCentros.").append(W83bPreavisosBD.cod_territorio).append(", ");
				strSql.append(" vistaSinCentros.").append(W83bPreavisosBD.anyo_eleccion).append(", ");
				strSql.append(" vistaSinCentros.").append(W83bPreavisosBD.num_preaviso).append(", ");
				strSql.append(" vistaSinCentros.").append(W83bPreavisosBD.fecha_entrada).append(", ");
				strSql.append(" vistaSinCentros.").append(W83bPreavisosBD.fecha_inicio).append(", ");
				strSql.append(" vistaSinCentros.").append(W83bPreavisosBD.fecha_eleccion).append(", ");
				strSql.append(" centros.").append(W83bCentroTrabajoBD.razonSocial).append(", ");
				strSql.append(" centros.").append(W83bCentroTrabajoBD.codigoCentro).append(", ");
				strSql.append(" centros.").append(W83bCentroTrabajoBD.codNifCif).append(", ");
				strSql.append(" centros.").append(W83bCentroTrabajoBD.ncentroTrab).append(", ");
				
				/*if (W83bClsConstantes.CONSTANTE_CASTELLANO.equals(param.getIdioma()))
				{
					strSql.append(" centros.").append(W83bPreavisosBD.TERRITORIO).append(",");

				}
				else
				{
					strSql.append(" centros.").append(W83bPreavisosBD.TERRITORIO_EUSK).append(",");
				}
				if (W83bClsConstantes.CONSTANTE_CASTELLANO.equals(param.getIdioma()))
				{
					strSql.append(" centros.").append(W83bPreavisosBD.MUNICIPIO).append(",");

				}
				else
				{
					strSql.append(" centros.").append(W83bPreavisosBD.MUNICIPIO).append(",");
				}*/
				strSql.append(" centros.").append(W83bCentroTrabajoBD.codProvinciaCentro).append(",");
				strSql.append(" centros.").append(W83bCentroTrabajoBD.codMunicipioCentro).append(",");
				if (W83bClsConstantes.CONSTANTE_CASTELLANO.equals(param.getIdioma()))
				{
					strSql.append(W83bPreavisosBD.desc_convenio).append(",");

				}
				else
				{
					strSql.append(W83bPreavisosBD.dese_convenio).append(",");
				}
				//strSql.append(" centros.").append(W83bPreavisosBD.NUM_TRABAJADORES).append(", ");
				strSql.append(" vistaSinCentros.").append(W83bPreavisosBD.eleccion_parcial).append(", ");
				strSql.append(" vistaSinCentros.").append(W83bPreavisosBD.preaviso_global).append(", ");
				strSql.append(" vistaSinCentros.").append(W83bPreavisosBD.cod_convenio).append(", ");
				strSql.append(" vistaSinCentros.").append(W83bPreavisosBD.admon_empresa).append(", ");
				strSql.append(" vistaSinCentros.").append(W83bPreavisosBD.num_acta).append(", ");
				strSql.append(" vistaSinCentros.").append(W83bPreavisosBD.numeroImpugnaciones).append(", ");
				strSql.append(" vistaSinCentros.").append(W83bPreavisosBD.npreavisosintcompleto).append(", ");
				
				strSql.append(" vistaSinCentros.").append(W83bPreavisosBD.num_centros_afectados);
				
				//AHORA HAVING
				strSql.append(" HAVING ");
				strSql.append(" MAX( ").append(" vistaSinCentros.").append(W83bPreavisosBD.cod_tramite).append(")");
				strSql.append(" = ?");
				params.add(param.getCodTramite());

			}
		}
		
			
		
		strSql.append(" ORDER BY ").append(param.getIdColumna()).append(" ").append(param.getSort());			
		
		
		List listaPreavisos = W83bDataBase.executeQuery(strSql.toString(),params,W83bPreavisosBean.class,param.getUsuarioBean(), "BUSQUEDAPREAVISOS");
		
		return listaPreavisos;
	}
	
	public String adjuntarArchivoPreavisos(HashMap param) throws Exception {
		// TODO insertar archivo en la tabla correspondiente
		return "ok";
	}

	public void anyadirPromotores(W83bPreavisosBean param) throws Exception{
		StringBuffer strSql = new StringBuffer();
		List params = new ArrayList();
		//meto los promotores
		
		String[] codsPromotores = null;
		if (StringUtils.isNotEmpty(param.getCodsPromotores())){
			codsPromotores= param.getCodsPromotores().split(",");	
			strSql= new StringBuffer();
			params= new ArrayList();
			strSql.append("INSERT INTO ");
			strSql.append(W83bPreavisosBD.preavisos_sindicatos_table);
			strSql.append ("(");
			strSql.append(W83bPreavisosBD.n_preaviso_027);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.ano_preaviso_027);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.c_territ_027);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.c_sindi_027);
			strSql.append(")");
			strSql.append(" VALUES (?,?,?,?)");
			params.add(new Integer(param.getNum_preaviso()));
			params.add(new Integer(param.getAnyoPreaviso()));
			params.add(param.getCodTerritorio().toUpperCase());

			for (int i=0;i<codsPromotores.length;i++){
				params.add(codsPromotores[i]);
				W83bDataBase.executeTableMovement(strSql.toString(), params,param.getUsuarioBean());
				params.remove(params.size()-1);
			}
		}
	}
	
	public void insertarPreavisoOriginal(W83bPreavisosBean param) throws Exception
	{
		StringBuffer strSql = new StringBuffer();
		List params = new ArrayList();

		strSql = new StringBuffer();
		params = new ArrayList();
		
		strSql.append("INSERT INTO ");
		strSql.append(W83bPreavisosBD.preavisos_originalesTable);
		strSql.append("(");
		strSql.append(W83bPreavisosBD.ano_preaviso_053);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.n_preaviso_053);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.f_inicio_053);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.f_elecc_053);
		strSql.append(",");
		
		strSql.append(W83bPreavisosBD.s_parcial_053);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.global_053);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.observ_053);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.usua_053);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.factu_053);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.convacu_053);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.admonemp_053);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.n_cenafec_053);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.fenvio_053);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.usuenv_053);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.ncarprocelec_053);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.oid8501_053);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.nop_053);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.c_territ_053);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.ndf_053);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.c_conv_053);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.dir_alt_053);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.codPos_alt_053);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.mun_alt_053);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.prov_alt_053);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.nif_centro_053);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.num_centro_053);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.raz_social_053);
		strSql.append(")");
		
		strSql.append(" VALUES (?,?,to_date(?,?),");
		
		if (StringUtils.isNotEmpty(param.getFecha_eleccion())){
			strSql.append("to_date(?,?)");
		}else{
			strSql.append("?");			
		}
		
		strSql.append(",?,?,?,?,to_date(?,?),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
		
		params.add(new Integer(param.getAnyoPreaviso()));
		params.add(new Integer(param.getNum_preaviso()));
		//TODO obtener el id del centro
		params.add(param.getFecha_inicio());
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		if (StringUtils.isNotEmpty(param.getFecha_eleccion())){
			params.add(param.getFecha_eleccion());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}else{
			params.add(W83bClsConstantes.NULL_DATE);			
		}
		
		if (StringUtils.isNotEmpty(param.getEleccion_parcial())){
			params.add(param.getEleccion_parcial().toUpperCase());
		}else{
			params.add("N");
		}
		if (StringUtils.isNotEmpty(param.getPreaviso_global().toUpperCase())){
			params.add(param.getPreaviso_global().toUpperCase());
		}else{
			params.add("N");
		}
		if (StringUtils.isNotEmpty(param.getObservaciones().toUpperCase())){
			params.add(param.getObservaciones().toUpperCase());
		}else{
			params.add(W83bClsConstantes.NULL_STRING);			
		}
		//USUA??
		params.add(W83bClsConstantes.NULL_STRING);
		
		params.add(W83bDateUtil.getInstance().getCurrentDateTime(W83bDateUtil.ES_PATTERN));
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(W83bClsConstantes.CONSTANTE_CASTELLANO));
		params.add(W83bClsConstantes.NULL_INTEGER);

		if (StringUtils.isNotEmpty(param.getAdmon())){
			params.add(param.getAdmon().toUpperCase());

		}else{
				params.add("N");
		}
		
		if (StringUtils.isNotEmpty(param.getNum_centros_afectados())){
			params.add(new Integer(param.getNum_centros_afectados()));
		}else{
			params.add(W83bClsConstantes.NULL_INTEGER);			
		}
		//FENVIO??
		params.add(W83bClsConstantes.NULL_DATE);
		//USUENV??
		params.add(W83bClsConstantes.NULL_STRING);
		//ncarpprocelec??
		params.add(W83bClsConstantes.NULL_INTEGER);
		//OID??
		params.add(W83bClsConstantes.NULL_INTEGER);
		//NOP??
		params.add(W83bClsConstantes.NULL_INTEGER);
		params.add(param.getCodTerritorio().toUpperCase());
		//NDF??
		params.add(W83bClsConstantes.NULL_STRING);
		
		if (StringUtils.isNotEmpty(param.getCodConvenio())){
			params.add(Integer.valueOf(param.getCodConvenio()));
		}else{
			params.add(W83bClsConstantes.NULL_INTEGER);
		}
		if (StringUtils.isNotEmpty(param.getDirAlternativa())){
			params.add(param.getDirAlternativa());
		}else{
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if (StringUtils.isNotEmpty(param.getCodPostalAlternativa())){
			params.add(param.getCodPostalAlternativa());
		}else{
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if (StringUtils.isNotEmpty(param.getCodMunicipio_alt())){
			params.add(param.getCodMunicipio_alt());
		}else{
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if (StringUtils.isNotEmpty(param.getIdProvincia_alt())){
			params.add(param.getIdProvincia_alt());
		}else{
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if (StringUtils.isNotEmpty(param.getCentroTrabajo().getCifnif())){
			params.add(param.getCentroTrabajo().getCifnif().toUpperCase());
		}else{
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if (StringUtils.isNotEmpty(param.getCentroTrabajo().getNumCentro())){
			params.add(param.getCentroTrabajo().getNumCentro());
		}else{
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if (StringUtils.isNotEmpty(param.getCentroTrabajo().getRazonSocial())){
			params.add(param.getCentroTrabajo().getRazonSocial());
		}else{
			params.add(W83bClsConstantes.NULL_STRING);
		}

		W83bDataBase.executeTableMovement(strSql.toString(), params,param.getUsuarioBean());
		
		//inserto los promotores del preaviso original
		strSql = new StringBuffer();
		params = new ArrayList();
		
		String[] codsPromotores = null;
		if (StringUtils.isNotEmpty(param.getCodsPromotores()))
		{
			codsPromotores= param.getCodsPromotores().split(",");	
			strSql= new StringBuffer();
			params= new ArrayList();
			strSql.append("INSERT INTO ");
			strSql.append(W83bPreavisosBD.preaviso_original_sindicatos_table);
			strSql.append ("(");
			strSql.append(W83bPreavisosBD.n_preaviso_054);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.ano_preaviso_054);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.c_territ_054);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.c_sindi_054);
			strSql.append(")");
			strSql.append(" VALUES (?,?,?,?)");
			params.add(new Integer(param.getNum_preaviso()));
			params.add(new Integer(param.getAnyoPreaviso()));
			params.add(param.getCodTerritorio().toUpperCase());

			for (int i=0;i<codsPromotores.length;i++)
			{
				params.add(codsPromotores[i]);
				W83bDataBase.executeTableMovement(strSql.toString(), params,param.getUsuarioBean());
				params.remove(params.size()-1);
			}
		}
		
		
	}
	
	public String insertarDocsPreavisos(W83bPreavisosBean param) throws Exception
	{
		StringBuffer strSql = new StringBuffer();
		StringBuffer strSql2 = new StringBuffer();
		List params = new ArrayList();
		
		String resultado = "";
		
		
		//voy a insertar los documentos adjuntos
		if (param.getListaDocs().size()>0)
		{
			StringBuffer strSqlCorrelativo = new StringBuffer();
			strSqlCorrelativo.append("SELECT MAX(");
			strSqlCorrelativo.append(W83bPreavisosBD.id_docu_038);
			strSqlCorrelativo.append(") FROM ");
			strSqlCorrelativo.append(W83bPreavisosBD.preavisos_docsTable);
			
			List idDoc = W83bDataBase.executeSimpleQuery(strSqlCorrelativo.toString(),new ArrayList(),null);
			int idDocNext=1;
			
			if (idDoc!=null && idDoc.size()>0 && idDoc.get(0)!=null)
			{
				idDocNext=Integer.parseInt(idDoc.get(0).toString())+1;
			}
			strSql = new StringBuffer();
			params = new ArrayList();

			strSql.append("INSERT INTO ");
			strSql.append(W83bPreavisosBD.preavisos_docsTable);
			
			strSql.append("(");
			strSql.append(W83bPreavisosBD.id_docu_038);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.nomb_docu_038);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.long_docu_038);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.docu_038);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.c_territ_038);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.c_tram_038);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.c_fase_038);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.ano_preaviso_038);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.n_preaviso_038);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.tp_doc_038);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.num_reg_038);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.f_reg_038);
			strSql.append(",");
			strSql.append(W83bPreavisosBD.usuario_038);
			strSql.append(")");
			

			strSql.append(" VALUES (?,?,?,?,?,?,?,?,?,?,?,");
			strSql2.append(strSql);
			if ("1".equals(param.getUsuarioBean().getRegManual())){
				strSql.append("to_date(?,?)");				
			}else{
				strSql.append("?");				
			}
			strSql2.append("?");				
			
			strSql.append(",?)");
			strSql2.append(",?)");
			
			
			StringBuffer strSqlLibro = new StringBuffer();
			ArrayList paramsLibro = new ArrayList();
			 
			strSqlLibro.append("UPDATE ") ;
			strSqlLibro.append(W83bPreavisosBD.preavisos_docsTable);
			strSqlLibro.append(" SET ");
			strSqlLibro.append(W83bPreavisosBD.f_reg_038);
			strSqlLibro.append(" = to_date(?,'"+W83bClsConstantes.FORMATO_FECHA_COMPLETA_CASTELLANO+"')");
			strSqlLibro.append(",");
			strSqlLibro.append(W83bPreavisosBD.num_reg_038);
			strSqlLibro.append(" = ?");
			strSqlLibro.append(" WHERE ").append(W83bPreavisosBD.c_territ_038).append(" = ? ");
			strSqlLibro.append(" AND ").append(W83bPreavisosBD.ano_preaviso_038).append(" = ? ");
			strSqlLibro.append(" AND ").append(W83bPreavisosBD.n_preaviso_038).append(" = ? ");
			strSqlLibro.append(" AND ").append(W83bPreavisosBD.id_docu_038).append(" = ? ");
			
			StringBuffer strSqlFinal = new StringBuffer();
			
			String[] codsPromotores= param.getCodsPromotores().split(",");
			 StringBuffer codPromotores = new StringBuffer(W83bClsConstantes.UNO);				 
			 
			 codPromotores.append(codsPromotores[0]);
			 
			for (int j=0;j<codsPromotores.length;j++){
				codPromotores.append("-").append(codsPromotores[j]);
				
			}
			
			for (int i=0;i<param.getListaDocs().size();i++)
			{
				strSqlFinal =  new StringBuffer(W83bClsConstantes.CUARENTA);//NOPMD
				strSqlFinal.append(strSql);
				W83bDocBean doc=(W83bDocBean)param.getListaDocs().get(i);
				//esto no va a ser asi cuando pongan la secuencia
				params.add(new Integer(idDocNext));//NOPMD
				
				params.add(doc.getNombre().toUpperCase());
				params.add(new Integer(doc.getTamanyo()));//NOPMD
				params.add(doc.getFileData());
				params.add(param.getCodTerritorio().toUpperCase());
				if (StringUtils.isNotEmpty(doc.getCodTramite()))
				{
					params.add(doc.getCodTramite().toUpperCase());
					
				}
				else
				{
					params.add("1");
				}
				//la fase siempre va a ser 1
				params.add("1");
				params.add(param.getAnyoPreaviso().toUpperCase());
				params.add(param.getNumPreaviso());
				params.add (doc.getTipoDocumento().toUpperCase());
				if ("1".equals(param.getUsuarioBean().getRegManual()))
				{
					if(StringUtils.isNotEmpty(doc.getNumeroRegistro())){
						params.add(doc.getNumeroRegistro());							
					}else{
						params.add(W83bClsConstantes.NULL_STRING);						
					}
					if(StringUtils.isNotEmpty(doc.getFechaRegistro())){
						params.add(doc.getFechaRegistro());							
						params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
					}else{
						strSqlFinal =  new StringBuffer(W83bClsConstantes.CUARENTA);//NOPMD
						strSqlFinal.append(strSql2);
						params.add(W83bClsConstantes.NULL_DATE);						
					}					
				}
				else
				{
					params.add(W83bClsConstantes.NULL_STRING);
					params.add(W83bClsConstantes.NULL_DATE);
				}				
				params.add(doc.getUsuario().toUpperCase());
				
				W83bDataBase.executeBlobTableMovement(strSqlFinal.toString(), params,doc.getTamanyo(),param.getUsuarioBean());
				
				params.clear();
				if ("0".equals(param.getUsuarioBean().getRegManual()))
				{
					//libro de registro
//					W83bLibroRegistroBean libroRegBean=W83bUtilidadesLibroRegistro.registrarLibroRegistro(param.getUsuarioBean());
					//Libro Registro
					
					String observaciones="Preavisos n: "+param.getCodTerritorio()+"/"+param.getAnyoPreaviso()+"/"+param.getNum_preaviso();//NOPMD
					 String empresa="";					 
					 				 
					 empresa=codPromotores.toString();
					
					 W83bUsuarioXLNetsBean usuarioLimitado = ((W83bIComunes)(W83bComunes.class.newInstance())).refrescarUsuarioDelegacion(param.getUsuarioBean());
					 
					 param.getUsuarioBean().setModelo(usuarioLimitado.getModelo());
					 param.getUsuarioBean().setModeloSal(usuarioLimitado.getModeloSal());
					try{ 
						String [] resul=W83bLibroRegistro.getAltaRegistro(true, param.getUsuarioBean().getModelo(), "E", "E", empresa, param.getCodTerritorio(), "", observaciones, param.getUsuarioBean());
						//Fin Libro Registro
						paramsLibro.add(resul[1]);
						paramsLibro.add(resul[0]);
						paramsLibro.add(param.getCodTerritorio());
						paramsLibro.add(new Integer(param.getAnyoPreaviso()));//NOPMD
						paramsLibro.add(new Integer(param.getNum_preaviso()));//NOPMD
						paramsLibro.add(new Integer(idDocNext));//NOPMD
						
						W83bDataBase.executeTableMovement(strSqlLibro.toString(), paramsLibro,param.getUsuarioBean());
					}catch (W83bLibroRegistroException e) {
						// TODO: handle exception
						resultado = "true";
					}
				}
				paramsLibro.clear();
				idDocNext++;
			}
		}
		return resultado;
	}
	
	
	public String maxCodPreavisos(W83bPreavisosBean param)throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT MAX(");
		strSql.append(W83bPreavisosBD.n_preaviso_037);
		
		strSql.append(") FROM ").append(W83bPreavisosBD.preavisosTable);
		strSql.append(" WHERE ").append(W83bPreavisosBD.ano_preaviso_037).append(" = ? ");
		strSql.append(" AND ").append(W83bPreavisosBD.c_territ_037).append(" = ? ");
		
		params.add(param.getAnyoPreaviso());
		params.add(param.getCodTerritorio());
		
		List listaPreavisos = W83bDataBase.executeSimpleQuery(strSql.toString(),params,null);
		
		String resultado = "0";
			
		if(null!=listaPreavisos.get(0)){
			resultado = listaPreavisos.get(0).toString();
		}
		
		return resultado; 		
	}
	
	
	public String contarPreavisos(W83bPreavisosBean param)throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT COUNT(");
		strSql.append(W83bPreavisosBD.n_preaviso_037);
		
		strSql.append(") FROM ").append(W83bPreavisosBD.preavisosTable);
		strSql.append(" WHERE ").append(W83bPreavisosBD.ano_preaviso_037).append(" = ? ");
		strSql.append(" AND ").append(W83bPreavisosBD.c_territ_037).append(" = ? ");
		
		params.add(param.getAnyoPreaviso());
		params.add(param.getCodTerritorio());
		
		List listaPreavisos = W83bDataBase.executeSimpleQuery(strSql.toString(),params,null);
		
		return listaPreavisos.get(0).toString(); 		
	}
	
	
	/**
	 * @param param
	 * @return
	 * @throws Exception
	 */
	public boolean existePreaviso(W83bPreavisosBean param,String numPreaviso) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		strSql.append(W83bPreavisosBD.n_preaviso_037);
		
		strSql.append(" FROM ").append(W83bPreavisosBD.preavisosTable);
		strSql.append(" WHERE ").append(W83bPreavisosBD.ano_preaviso_037).append(" = ? ");
		strSql.append(" AND ").append(W83bPreavisosBD.c_territ_037).append(" = ? ");
		strSql.append(" AND ").append(W83bPreavisosBD.n_preaviso_037).append(" = ? ");
		
		
		params.add(param.getAnyoPreaviso());
		params.add(param.getCodTerritorio());
		params.add(numPreaviso);
		
		List listaPreavisos = W83bDataBase.executeSimpleQuery(strSql.toString(),params,null);
		
		
		if(listaPreavisos.size()>0){
			return true;
		}
		
		return false;		
	}
	
	
	public HashMap calcularNumPreaviso(W83bPreavisosBean param) throws Exception {
		HashMap res=new HashMap();
		String resultado = "0";
		String fechaRegistro="";
		if(StringUtils.isEmpty(param.getNum_preaviso())){
			String maxPreaviso = W83bFactoriaDAO.getPreavisosDAO().maxCodPreavisos(param);
			if(W83bPreavisosBD.maxNumPreaviso.equals(maxPreaviso)){
				boolean codEncontrado = false;
				if(Integer.parseInt(maxPreaviso)+1
						!=Integer.parseInt(W83bFactoriaDAO.getPreavisosDAO().contarPreavisos(param))){
					while(!codEncontrado){
						maxPreaviso = String.valueOf(Integer.parseInt(maxPreaviso)-1);//NOPMD
						codEncontrado = !W83bFactoriaDAO.getPreavisosDAO().existePreaviso(param,maxPreaviso);
					}
					int tamanyo = maxPreaviso.length();
					for(int i=tamanyo;i<6;i++){
						maxPreaviso = "0"+maxPreaviso;//NOPMD
					}
					param.setNum_preaviso(maxPreaviso);
					resultado = param.getNum_preaviso();
//					fechaRegistro=W83bFactoriaDAO.getPreavisosDAO().anyadirPreavisos(param);	
					res.put("numPreaviso", resultado);
					res.put("fechaRegistro", fechaRegistro);
				}else{
					resultado = "-1";
					res.put("numPreaviso", resultado);
					res.put("fechaRegistro", fechaRegistro);
					return res;
				}
			}else{				
				maxPreaviso = String.valueOf(Integer.parseInt(maxPreaviso)+1);//NOPMD
				int tamanyo = maxPreaviso.length();
				for(int i=tamanyo;i<6;i++){
					maxPreaviso = "0"+maxPreaviso;//NOPMD
				}
				param.setNum_preaviso(maxPreaviso);		
				resultado = maxPreaviso;
//				fechaRegistro=W83bFactoriaDAO.getPreavisosDAO().anyadirPreavisos(param);	
				res.put("numPreaviso", resultado);
				res.put("fechaRegistro", fechaRegistro);
			}
		}else {
			if(!W83bFactoriaDAO.getPreavisosDAO().existePreaviso(param,param.getNum_preaviso())){
				int tamanyo = param.getNum_preaviso().length();
				for(int i=tamanyo;i<6;i++){
					param.setNum_preaviso("0"+param.getNum_preaviso());
				}
//				fechaRegistro=W83bFactoriaDAO.getPreavisosDAO().anyadirPreavisos(param);	
				resultado = param.getNum_preaviso();
				res.put("numPreaviso", resultado);
				res.put("fechaRegistro", fechaRegistro);
			}else{
				resultado = "-2";				
				res.put("numPreaviso", resultado);
				res.put("fechaRegistro", fechaRegistro);
			}
		}	
		return res;
	}
	
	public HashMap anyadirPreavisos(W83bPreavisosBean param) throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		String fechaRegistro="";
		strSql.append("INSERT INTO ");
		strSql.append(W83bPreavisosBD.preavisosTable);
		
		strSql.append("(");
		strSql.append(W83bPreavisosBD.ano_preaviso_037);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.n_preaviso_037);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.id_centro_037);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.f_entra_037);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.f_inicio_037);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.f_elecc_037);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.f_regis_037);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.n_regis_037);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.ano_acta_037);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.n_acta_037);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.s_parcial_037);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.global_037);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.observ_037);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.usua_037);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.factu_037);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.convacu_037);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.admonemp_037);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.n_cenafec_037);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.fenvio_037);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.usuenv_037);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.ncarprocelec_037);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.oid8501_037);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.nop_037);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.c_territ_037);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.ndf_037);
		strSql.append(",");
	
		strSql.append(W83bPreavisosBD.c_conv_037);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.dir_alt_037);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.codPos_alt_037);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.mun_alt_037);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.prov_alt_037);

		strSql.append(")");
		
		strSql.append(" VALUES (?,?,?,to_date(?,?),to_date(?,?),");
		if(StringUtils.isNotEmpty(param.getFecha_eleccion())){
			strSql.append("to_date(?,?)");
		}else{
			strSql.append("?");			
		}
		if ("1".equals(param.getUsuarioBean().getRegManual())){
			if(StringUtils.isNotEmpty(param.getFecha_registro())){
				strSql.append(",to_date(?,?),?,");
			}else{
				strSql.append(",?,?,");
			}
		}else{
			strSql.append(",?,?,");		
		}
		
		strSql.append("?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
		
		params.add(new Integer(param.getAnyoPreaviso()));
		
		HashMap mapa = W83bFactoriaDAO.getPreavisosDAO().calcularNumPreaviso(param);
		
		
		
		params.add(new Integer(param.getNum_preaviso()));
		//TODO obtener el id del centro
		params.add(new Integer(param.getIdCentroTrabajo()));
		params.add(param.getFecha_entrada());
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(param.getFecha_inicio());
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		if(StringUtils.isNotEmpty(param.getFecha_eleccion())){
			params.add(param.getFecha_eleccion());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}else{
			params.add(W83bClsConstantes.NULL_DATE);
		}
		//Fecha de registro
		if ("1".equals(param.getUsuarioBean().getRegManual()))
		{
			if(StringUtils.isNotEmpty(param.getFecha_registro())){
				params.add(param.getFecha_registro());
				params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
			}else{
				params.add(W83bClsConstantes.NULL_DATE);
			}
			if(StringUtils.isNotEmpty(param.getNum_registro())){
				//Numero de registro
				params.add(param.getNum_registro());
			}else{
				params.add(W83bClsConstantes.NULL_STRING);
			}
			fechaRegistro=param.getFecha_registro();
		}
		else
		{
			params.add(W83bClsConstantes.NULL_DATE);
			//Numero de registro
			params.add(W83bClsConstantes.NULL_STRING);
		}
		
		if(StringUtils.isNotEmpty(param.getAnyo_acta())){
			params.add(param.getAnyo_acta().toUpperCase());
		}else{
			params.add(W83bClsConstantes.NULL_STRING);			
		}
		if(StringUtils.isNotEmpty(param.getNum_acta())){
			params.add(param.getNum_acta().toUpperCase());
		}else{
			params.add(W83bClsConstantes.NULL_STRING);			
		}
		if (StringUtils.isNotEmpty(param.getEleccion_parcial())){
			params.add(param.getEleccion_parcial().toUpperCase());
		}else{
			params.add("N");
		}
		if (StringUtils.isNotEmpty(param.getPreaviso_global())){
			params.add(param.getPreaviso_global().toUpperCase());
		}else{
			params.add("N");
		}
		if(StringUtils.isNotEmpty(param.getObservaciones())){
			params.add(param.getObservaciones().toUpperCase());
		}else{
			params.add(W83bClsConstantes.NULL_STRING);			
		}
		//USUA??
		params.add(W83bClsConstantes.NULL_STRING);
		//FACTU_037??
		params.add(W83bClsConstantes.NULL_DATE);
		params.add(W83bClsConstantes.NULL_INTEGER);

		if (StringUtils.isNotEmpty(param.getAdmon())){
			params.add(param.getAdmon().toUpperCase());

		}else{
				params.add("N");
		}
		if(StringUtils.isNotEmpty(param.getNum_centros_afectados())){
			params.add(new Integer(param.getNum_centros_afectados()));
		}else{
			params.add(W83bClsConstantes.NULL_INTEGER);			
		}
		//FENVIO??
		params.add(W83bClsConstantes.NULL_DATE);
		//USUENV??

		params.add(W83bClsConstantes.NULL_STRING);
		//ncarpprocelec??
		params.add(W83bClsConstantes.NULL_INTEGER);
		//OID??
		params.add(W83bClsConstantes.NULL_INTEGER);
		//NOP??
		params.add(W83bClsConstantes.NULL_INTEGER);
		params.add(param.getCodTerritorio());
		//NDF??
		params.add(W83bClsConstantes.NULL_STRING);
	
		
		if (StringUtils.isNotEmpty(param.getCodConvenio())){
			params.add(Integer.valueOf(param.getCodConvenio()));
		}else{
			params.add(W83bClsConstantes.NULL_INTEGER);
		}
		if (StringUtils.isNotEmpty(param.getDirAlternativa())){
			params.add(param.getDirAlternativa());
		}else{
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if (StringUtils.isNotEmpty(param.getCodPostalAlternativa())){
			params.add(param.getCodPostalAlternativa());
		}else{
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if (StringUtils.isNotEmpty(param.getCodMunicipio_alt())){
			params.add(param.getCodMunicipio_alt());
		}else{
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if (StringUtils.isNotEmpty(param.getIdProvincia_alt())){
			params.add(param.getIdProvincia_alt());
		}else{
			params.add(W83bClsConstantes.NULL_STRING);
		}
		
		W83bDataBase.executeTableMovement(strSql.toString(), params,param.getUsuarioBean());
		
		//libro de registro
		if ("0".equals(param.getUsuarioBean().getRegManual()))
		{
//			W83bLibroRegistroBean libroRegBean=W83bUtilidadesLibroRegistro.registrarLibroRegistro(param.getUsuarioBean());
			//Libro Registro
			
			String observaciones="Preavisos n: "+param.getCodTerritorio()+"/"+param.getAnyoPreaviso()+"/"+param.getNum_preaviso();
			 String empresa="";
			 String[] codsPromotores= param.getCodsPromotores().split(",");
			 StringBuffer codPromotores = new StringBuffer(W83bClsConstantes.UNO);				 
			 
			 codPromotores.append(codsPromotores[0]);
			 
			for (int j=1;j<codsPromotores.length;j++){
				codPromotores.append("-").append(codsPromotores[j]);
				
			}
			
			empresa = codPromotores.toString();
			try{	
				String [] resul=W83bLibroRegistro.getAltaRegistro(true, param.getUsuarioBean().getModelo(), "E", "E", empresa, param.getCodTerritorio(), "", observaciones, param.getUsuarioBean());
				
				param.setFecha_registro(resul[1]);
				param.setNum_registro(resul[0]);
				
				//Fin Libro Registro
				strSql = new StringBuffer();
				params = new ArrayList();
				 
				strSql.append("UPDATE ") ;
				strSql.append(W83bPreavisosBD.preavisosTable);
				strSql.append(" SET ");
				strSql.append(W83bPreavisosBD.f_regis_037);
				strSql.append(" = to_date(?,'"+W83bClsConstantes.FORMATO_FECHA_COMPLETA_CASTELLANO+"')");
				strSql.append(",");
				strSql.append(W83bPreavisosBD.n_regis_037);
				strSql.append(" = ?");
				strSql.append(" WHERE ").append(W83bPreavisosBD.c_territ_037).append(" = ? ");
				strSql.append(" AND ").append(W83bPreavisosBD.ano_preaviso_037).append(" = ? ");
				strSql.append(" AND ").append(W83bPreavisosBD.n_preaviso_037).append(" = ? ");
				
	//			params.add(resul[1]);
	//			params.add(resul[0]);
				params.add(param.getFecha_registro());
				params.add(param.getNum_registro());
				params.add(param.getCodTerritorio());
				params.add(new Integer(param.getAnyoPreaviso()));
				params.add(new Integer(param.getNum_preaviso()));
				fechaRegistro=param.getFecha_registro();
				
				W83bDataBase.executeTableMovement(strSql.toString(), params,param.getUsuarioBean());
			}catch (W83bLibroRegistroException e) {
				
			}
		}
		

		//dar de alta en el historial
		CallableStatement cs;
	    cs = W83bDataBase.getConnection().prepareCall("{call w83b.w83bHistorialPreavisos(?,?,?,?,?,?,?)}");
	    cs.setInt(1, Integer.parseInt(param.getNum_preaviso()));
	    cs.setInt(2, Integer.parseInt(param.getAnyoPreaviso()));
	    cs.setString(3, param.getCodTerritorio().toUpperCase());
	    cs.setString(4, W83bDateUtil.getInstance().getCurrentDateTime(W83bDateUtil.ES_PATTERN_HORA));
	    cs.setString(5, param.getUsuarioBean().getIdUsuario());
	    cs.setString(6,Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun", "comun.historial.insertpreaviso", W83bClsConstantes.CONSTANTE_CASTELLANO));
	    cs.setString(7,Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun", "comun.historial.insertpreaviso", W83bClsConstantes.CONSTANTE_EUSKARA));
	    cs.execute();
	    mapa.put("fechaRegistro",fechaRegistro);
	    return mapa;
	}
	
	public void editarPreavisos(W83bPreavisosBean param) throws Exception {
		String [] codPreaviso=param.getCodSelec().split("_");

		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		strSql.append("UPDATE ");
		strSql.append(W83bPreavisosBD.preavisosTable);
		strSql.append(" SET ");
		strSql.append(W83bPreavisosBD.id_centro_037);
		strSql.append(" = ?");
		strSql.append(",");
		strSql.append(W83bPreavisosBD.f_entra_037);
		strSql.append(" = to_date(?,?)");
		strSql.append(",");
		strSql.append(W83bPreavisosBD.f_inicio_037);
		strSql.append(" = to_date(?,?)");
		strSql.append(",");
		if (StringUtils.isNotEmpty(param.getFecha_eleccion())){
			strSql.append(W83bPreavisosBD.f_elecc_037);
			strSql.append(" = to_date(?,?)");
		}else{
			strSql.append(W83bPreavisosBD.f_elecc_037);
			strSql.append(" = ?");			
		}
		strSql.append(",");
		if (StringUtils.isNotEmpty(param.getFecha_registro())){
			strSql.append(W83bPreavisosBD.f_regis_037);
			strSql.append(" = to_date(?,?)");
		}else{
			strSql.append(W83bPreavisosBD.f_regis_037);
			strSql.append(" = ?");			
		}
		strSql.append(",");
		strSql.append(W83bPreavisosBD.n_regis_037);
		strSql.append(" = ?");
		strSql.append(",");
		strSql.append(W83bPreavisosBD.s_parcial_037);
		strSql.append(" = ?");
		strSql.append(",");
		strSql.append(W83bPreavisosBD.global_037);
		strSql.append(" = ?");
		strSql.append(",");
		strSql.append(W83bPreavisosBD.observ_037);
		strSql.append(" = ?");
		strSql.append(",");
		strSql.append(W83bPreavisosBD.usua_037);
		strSql.append(" = ?");
		strSql.append(",");
		strSql.append(W83bPreavisosBD.factu_037);
		//TODO cambiar
		
		strSql.append(" = ?");
		strSql.append(",");
		strSql.append(W83bPreavisosBD.convacu_037);
		strSql.append(" = ?");
		strSql.append(",");
		strSql.append(W83bPreavisosBD.admonemp_037);
		strSql.append(" = ?");
		strSql.append(",");
		strSql.append(W83bPreavisosBD.n_cenafec_037);
		strSql.append(" = ?");
		strSql.append(",");
		strSql.append(W83bPreavisosBD.fenvio_037);
		strSql.append(" = ?");
		strSql.append(",");
		strSql.append(W83bPreavisosBD.usuenv_037);
		strSql.append(" = ?");
		strSql.append(",");
		strSql.append(W83bPreavisosBD.ncarprocelec_037);
		strSql.append(" = ?");
		strSql.append(",");
		strSql.append(W83bPreavisosBD.oid8501_037);
		strSql.append(" = ?");
		strSql.append(",");
		strSql.append(W83bPreavisosBD.nop_037);
		strSql.append(" = ?");
		strSql.append(",");
		strSql.append(W83bPreavisosBD.ndf_037);
		strSql.append(" = ?");
	
		strSql.append(",");
		strSql.append(W83bPreavisosBD.c_conv_037);
		strSql.append(" = ?");
		strSql.append(",");
		strSql.append(W83bPreavisosBD.dir_alt_037);
		strSql.append(" = ?");
		strSql.append(",");
		strSql.append(W83bPreavisosBD.codPos_alt_037);
		strSql.append(" = ?");
		strSql.append(",");
		strSql.append(W83bPreavisosBD.mun_alt_037);
		strSql.append(" = ?");
		strSql.append(",");
		strSql.append(W83bPreavisosBD.prov_alt_037);
		strSql.append(" = ?");
				
		strSql.append(" WHERE ").append(W83bPreavisosBD.c_territ_037).append(" = ? ");
		strSql.append(" AND ").append(W83bPreavisosBD.ano_preaviso_037).append(" = ? ");
		strSql.append(" AND ").append(W83bPreavisosBD.n_preaviso_037).append(" = ? ");
		
		if (StringUtils.isNotEmpty(param.getIdCentroTrabajo())){
			params.add(new Integer(param.getIdCentroTrabajo()));
		}else{
			params.add(W83bClsConstantes.NULL_INTEGER);
		}
		params.add(param.getFecha_entrada());
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(param.getFecha_inicio());
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		if (StringUtils.isNotEmpty(param.getFecha_eleccion())){
			params.add(param.getFecha_eleccion());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}else{
			params.add(W83bClsConstantes.NULL_DATE);			
		}
		if (StringUtils.isNotEmpty(param.getFecha_registro())){
			params.add(param.getFecha_registro());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}else{
			params.add(W83bClsConstantes.NULL_DATE);			
		}
		if (StringUtils.isNotEmpty(param.getNum_registro())){
			params.add(param.getNum_registro());
		}else{
			params.add(W83bClsConstantes.NULL_STRING);			
		}
		if (StringUtils.isNotEmpty(param.getEleccion_parcial())){
			params.add(param.getEleccion_parcial());
		}else{
			params.add("N");
		}
		if (StringUtils.isNotEmpty(param.getPreaviso_global())){
			params.add(param.getPreaviso_global());
		}else{
			params.add("N");
		}
		if (StringUtils.isNotEmpty(param.getObservaciones())){
			params.add(param.getObservaciones());
		}else{
			params.add(W83bClsConstantes.NULL_STRING);
		}
		//USUA??
		params.add(W83bClsConstantes.NULL_STRING);
		//FACTU_037??
		params.add(W83bClsConstantes.NULL_DATE);
		params.add(W83bClsConstantes.NULL_INTEGER);

		if (StringUtils.isNotEmpty(param.getAdmon())){
			params.add(param.getAdmon());

		}else{
				params.add("N");
		}
		if (StringUtils.isNotEmpty(param.getNum_centros_afectados())){
			params.add(new Integer(param.getNum_centros_afectados()));
		}else{
			params.add(W83bClsConstantes.NULL_INTEGER);
		}
		//FENVIO??
		params.add(W83bClsConstantes.NULL_DATE);
		//USUENV??
		//TODO cambiar a usuario xlnets
//		params.add("ALVARO");
		params.add(W83bClsConstantes.NULL_STRING);
		//ncarpprocelec??
		params.add(W83bClsConstantes.NULL_INTEGER);
		//OID??
		params.add(W83bClsConstantes.NULL_INTEGER);
		//NOP??
		params.add(W83bClsConstantes.NULL_INTEGER);
		//NDF??
		params.add(W83bClsConstantes.NULL_STRING);
	
		if (StringUtils.isNotEmpty(param.getCodConvenio())){
			params.add(param.getCodConvenio());
		}else{
			params.add(W83bClsConstantes.NULL_STRING);
		}
		
		if (StringUtils.isNotEmpty(param.getDirAlternativa())){
			params.add(param.getDirAlternativa());
		}else{
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if (StringUtils.isNotEmpty(param.getCodPostalAlternativa())){
			params.add(param.getCodPostalAlternativa());
		}else{
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if (StringUtils.isNotEmpty(param.getCodMunicipio_alt())){
			params.add(param.getCodMunicipio_alt());
		}else{
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if (StringUtils.isNotEmpty(param.getIdProvincia_alt())){
			params.add(param.getIdProvincia_alt());
		}else{
			params.add(W83bClsConstantes.NULL_STRING);
		}
		
		params.add(new String(codPreaviso[0]));		
		params.add(new Integer(codPreaviso[1]));
		params.add(new Integer(codPreaviso[2]));

		W83bDataBase.executeTableMovement(strSql.toString(), params,param.getUsuarioBean());
		
		CallableStatement cs;
		// Call a procedure with no parameters
	    cs = W83bDataBase.getConnection().prepareCall("{call w83b.w83bHistorialPreavisos(?,?,?,?,?,?,?)}");
	    cs.setInt(1, Integer.parseInt(param.getNum_preaviso()));
	    cs.setInt(2, Integer.parseInt(param.getAnyoPreaviso()));
	    cs.setString(3, param.getCodTerritorio().toUpperCase());
	    cs.setString(4, W83bDateUtil.getInstance().getCurrentDateTime(W83bDateUtil.ES_PATTERN_HORA));
	    cs.setString(5, param.getUsuarioBean().getIdUsuario());
	    cs.setString(6,Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun", "comun.historial.editpreaviso", W83bClsConstantes.CONSTANTE_CASTELLANO));
	    cs.setString(7,Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun", "comun.historial.editpreaviso", W83bClsConstantes.CONSTANTE_EUSKARA));
	    cs.execute();
	    
	/*    if(param.getListaDocs().size()>0){
	    	boolean sinEspecificar = true;
	    	for(int i=0,size=param.getListaDocs().size();i<size;i++){
	    		W83bDocBean doc=(W83bDocBean)param.getListaDocs().get(0);
	    		if(!W83bClsConstantes.TRAMITE_SINESPECIFICAR.equals(doc.getCodTramite())){
	    			sinEspecificar = false;
	    		}
	    	}
	    	if(!sinEspecificar){
			    if(buscaHistorialTramitacionPreavisos(param,W83bClsConstantes.FASE_TRAMITACION_PREAVISO,W83bClsConstantes.TRAMITE_RECEPCION_SOLICITUD).size()==0){
			    	//hay que coger la fecha del documento
			    	String fecha="";
			    		W83bDocBean doc=(W83bDocBean)param.getListaDocs().get(0);
			    		fecha=doc.getFechaRegistro();
			    		//cojo la fecha del primero
			    		anyadirHistorialTramitacion(param,W83bClsConstantes.FASE_TRAMITACION_PREAVISO,W83bClsConstantes.TRAMITE_RECEPCION_SOLICITUD,fecha);
			    }else{
			    	//actualizar la tabla de tramitacion
				    strSql = new StringBuffer();
					params = new ArrayList();
					strSql.append("UPDATE ") ;
					strSql.append(W83bPreavisosBD.historial_tramitacion_Synonym);
					strSql.append(" SET ");
					strSql.append(W83bPreavisosBD.usu_mod_056);
					strSql.append(" = ?");
					strSql.append(",");
					strSql.append(W83bPreavisosBD.f_modif_056);
					strSql.append(" = to_date(?,'"+W83bClsConstantes.FORMATO_FECHA_COMPLETA_CASTELLANO+"')");
					strSql.append(" WHERE ").append(W83bPreavisosBD.n_preaviso_056).append(" = ? ");
					strSql.append(" AND ").append(W83bPreavisosBD.ano_preaviso_056).append(" = ? ");
					strSql.append(" AND ").append(W83bPreavisosBD.c_territ_056).append(" = ? ");
					strSql.append(" AND ").append(W83bPreavisosBD.c_fase_056).append(" = ? ");
					strSql.append(" AND ").append(W83bPreavisosBD.c_tram_056).append(" = ? ");
					
					params.add(param.getUsuarioBean().getIdUsuario());
					SimpleDateFormat sdf =new SimpleDateFormat(W83bDateUtil.ES_PATTERN_HORA);
					params.add(sdf.format(new Date()));
			
					params.add(new String(codPreaviso[2]));		
					params.add(new Integer(codPreaviso[1]));
					params.add(new Integer(codPreaviso[0]));
					params.add(new Integer(W83bClsConstantes.FASE_TRAMITACION_PREAVISO));
					params.add(new Integer(W83bClsConstantes.TRAMITE_RECEPCION_SOLICITUD));
			    	
			    }
	    	}
	    }
	    
		
		W83bDataBase.executeTableMovement(strSql.toString(), params,param.getUsuarioBean());*/

	}

	public boolean borrarPreaviso(String param,W83bUsuarioXLNetsBean usuarioBean) throws Exception {
		// TODO Auto-generated method stub
		
		String [] codPreaviso=param.split("_");
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("DELETE FROM ");
		strSql.append(W83bPreavisosBD.preavisosTable);
		strSql.append(" WHERE ");
		strSql.append(W83bPreavisosBD.c_territ_037);
		strSql.append(" = ? ");
		strSql.append(" AND ");
		strSql.append(W83bPreavisosBD.ano_preaviso_037);
		strSql.append(" = ? ");
		strSql.append(" AND ");
		strSql.append(W83bPreavisosBD.n_preaviso_037);
		strSql.append(" = ? ");
		
		params.add(new String(codPreaviso[0]));		
		params.add(new Integer(codPreaviso[1]));
		params.add(new Integer(codPreaviso[2]));
		
		try
		{
			W83bDataBase.executeTableMovement(strSql.toString(), params,usuarioBean);

		}
		catch (SQLException e)
		{
			return false;
		}
	    
		return true;
	}
	
	public boolean borrarHistorialTramitacionPreaviso(String param,W83bUsuarioXLNetsBean usuarioBean) throws Exception {
		// TODO Auto-generated method stub
		
		String [] codPreaviso=param.split("_");
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("DELETE FROM ");
		strSql.append(W83bPreavisosBD.historial_tramitacion_Synonym);
		strSql.append(" WHERE ");
		strSql.append(W83bPreavisosBD.c_territ_056);
		strSql.append(" = ? ");
		strSql.append(" AND ");
		strSql.append(W83bPreavisosBD.ano_preaviso_056);
		strSql.append(" = ? ");
		strSql.append(" AND ");
		strSql.append(W83bPreavisosBD.n_preaviso_056);
		strSql.append(" = ? ");
		
		params.add(new String(codPreaviso[0]));		
		params.add(new Integer(codPreaviso[1]));
		params.add(new Integer(codPreaviso[2]));
		
		try
		{
			W83bDataBase.executeTableMovement(strSql.toString(), params,usuarioBean);
			
		}
		catch (SQLException e)
		{
			return false;
		}
		
		return true;
	}
	
	public boolean borrarDocsPreaviso(String param,W83bUsuarioXLNetsBean usuarioBean) throws Exception {
		// TODO Auto-generated method stub
		
		String [] codPreaviso=param.split("_");
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("DELETE FROM ");
		strSql.append(W83bPreavisosBD.preavisos_docsTable);
		strSql.append(" WHERE ");
		strSql.append(W83bPreavisosBD.c_territ_038);
		strSql.append(" = ? ");
		strSql.append(" AND ");
		strSql.append(W83bPreavisosBD.ano_preaviso_038);
		strSql.append(" = ? ");
		strSql.append(" AND ");
		strSql.append(W83bPreavisosBD.n_preaviso_038);
		strSql.append(" = ? ");
		
		params.add(new String(codPreaviso[0]));		
		params.add(new Integer(codPreaviso[1]));
		params.add(new Integer(codPreaviso[2]));
		
		try
		{
			W83bDataBase.executeTableMovement(strSql.toString(), params,usuarioBean);

		}
		catch (SQLException e)
		{
			return false;
		}
		return true;
	}
	
	public boolean borrarPreavisoOriginal(String param,W83bUsuarioXLNetsBean usuarioBean) throws Exception {
		// TODO Auto-generated method stub
		
		String [] codPreaviso=param.split("_");
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("DELETE FROM ");
		strSql.append(W83bPreavisosBD.preavisos_originalesTable);
		strSql.append(" WHERE ");
		strSql.append(W83bPreavisosBD.c_territ_053);
		strSql.append(" = ? ");
		strSql.append(" AND ");
		strSql.append(W83bPreavisosBD.ano_preaviso_053);
		strSql.append(" = ? ");
		strSql.append(" AND ");
		strSql.append(W83bPreavisosBD.n_preaviso_053);
		strSql.append(" = ? ");
		
		params.add(new String(codPreaviso[0]));		
		params.add(new Integer(codPreaviso[1]));
		params.add(new Integer(codPreaviso[2]));
		
		try
		{
			W83bDataBase.executeTableMovement(strSql.toString(), params,usuarioBean);

		}
		catch (SQLException e)
		{
			return false;
		}
		return true;
	}
	
	public boolean borrarPromotores(String param,W83bUsuarioXLNetsBean usuarioBean) throws Exception {
		// TODO Auto-generated method stub
		
		String [] codPreaviso=param.split("_");
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("DELETE FROM ");
		strSql.append(W83bPreavisosBD.preavisos_sindicatos_table);
		strSql.append(" WHERE ");
		strSql.append(W83bPreavisosBD.c_territ_027);
		strSql.append(" = ? ");
		strSql.append(" AND ");
		strSql.append(W83bPreavisosBD.ano_preaviso_027);
		strSql.append(" = ? ");
		strSql.append(" AND ");
		strSql.append(W83bPreavisosBD.n_preaviso_027);
		strSql.append(" = ? ");
		
		params.add(new String(codPreaviso[0]));		
		params.add(new Integer(codPreaviso[1]));
		params.add(new Integer(codPreaviso[2]));
		
		try
		{
			W83bDataBase.executeTableMovement(strSql.toString(), params,usuarioBean);

		}
		catch (SQLException e)
		{
			return false;
		}
		

		return true;
	}
	
	public List buscarImpugnacion(String param,W83bUsuarioXLNetsBean usuarioBean) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		String [] codPreaviso=param.split("_");
		
		strSql.append(" SELECT ");
		strSql.append(W83bImpugnacionesBD.n_impug).append(", ");
		strSql.append(W83bImpugnacionesBD.ano_impug);
		
		strSql.append(" FROM ").append(W83bImpugnacionesBD.tableImpugnaciones);
		strSql.append(" WHERE ");
		strSql.append(W83bImpugnacionesBD.n_preaviso);
		strSql.append(" = ? AND ");
		strSql.append(W83bImpugnacionesBD.ano_preaviso);
		strSql.append(" = ? AND ");
		strSql.append(W83bImpugnacionesBD.c_territ);
		strSql.append(" = ? ");
		params.add(new Integer(codPreaviso[2]));
		params.add(new Integer(codPreaviso[1]));
		params.add(new String(codPreaviso[0]));		
		
		List lista = W83bDataBase.executeQuery(strSql.toString(),params,usuarioBean);
						
		return lista;
	}
	
	public boolean borrarPromotoresPreavisoOriginal(String param,W83bUsuarioXLNetsBean usuarioBean) throws Exception {
		// TODO Auto-generated method stub
		
		String [] codPreaviso=param.split("_");
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("DELETE FROM ");
		strSql.append(W83bPreavisosBD.preaviso_original_sindicatos_table);
		strSql.append(" WHERE ");
		strSql.append(W83bPreavisosBD.c_territ_054);
		strSql.append(" = ? ");
		strSql.append(" AND ");
		strSql.append(W83bPreavisosBD.ano_preaviso_054);
		strSql.append(" = ? ");
		strSql.append(" AND ");
		strSql.append(W83bPreavisosBD.n_preaviso_054);
		strSql.append(" = ? ");
		
		params.add(new String(codPreaviso[0]));		
		params.add(new Integer(codPreaviso[1]));
		params.add(new Integer(codPreaviso[2]));
		
		try
		{
			W83bDataBase.executeTableMovement(strSql.toString(), params,usuarioBean);

		}
		catch (SQLException e)
		{
			return false;
		}

		return true;
	}
	
	public boolean borrarHistorial(String param,W83bUsuarioXLNetsBean usuarioBean) throws Exception {
		// TODO Auto-generated method stub
		
		String [] codPreaviso=param.split("_");
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("DELETE FROM ");
		strSql.append(W83bPreavisosBD.preaviso_historial_Synonym);
		strSql.append(" WHERE ");
		strSql.append(W83bPreavisosBD.c_territ_055);
		strSql.append(" = ? ");
		strSql.append(" AND ");
		strSql.append(W83bPreavisosBD.ano_preaviso_055);
		strSql.append(" = ? ");
		strSql.append(" AND ");
		strSql.append(W83bPreavisosBD.n_preaviso_055);
		strSql.append(" = ? ");
		
		params.add(new String(codPreaviso[0]));		
		params.add(new Integer(codPreaviso[1]));
		params.add(new Integer(codPreaviso[2]));
		
		try
		{
			W83bDataBase.executeTableMovement(strSql.toString(), params,usuarioBean);

		}
		catch (SQLException e)
		{
			return false;
		}
		return true;
	}
	
	public String insertarHistorialTramitacion(String codSelec,String user)throws Exception {
		String [] codPreaviso=codSelec.split("_");
		CallableStatement cs;
		// Call a procedure with no parameters
	    cs = W83bDataBase.getConnection().prepareCall("{call w83b.w83bHistorialPreavisos(?,?,?,?,?,?,?)}");
	    cs.setInt(1, Integer.parseInt(codPreaviso[2]));
	    cs.setInt(2, Integer.parseInt(codPreaviso[1]));
	    cs.setString(3, codPreaviso[0]);
	    cs.setString(4, W83bDateUtil.getInstance().getCurrentDateTime(W83bDateUtil.ES_PATTERN_HORA));
	    cs.setString(5, user);
	    cs.setString(6,Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun", "comun.historial.accesopreaviso", W83bClsConstantes.CONSTANTE_CASTELLANO));
	    cs.setString(7,Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun", "comun.historial.accesopreaviso", W83bClsConstantes.CONSTANTE_EUSKARA));
	    cs.execute();
	    return "0";
	}
	
	public W83bPreavisosBean obtenerRegDefinitivoActaPreaviso(W83bPreavisosBean preaviso)throws Exception {
			StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
			List params = new ArrayList();
			strSql.append("SELECT ");
			strSql.append(W83bActasBD.numRegDefinitivo).append(",to_char(");
			strSql.append(W83bActasBD.fecRegDefinitivo);
			strSql.append(",?) as ").append(W83bActasBD.fecRegDefinitivo);
			strSql.append(" FROM ");
			strSql.append(W83bActasBD.actasTable).append(" WHERE ");
			strSql.append(W83bActasBD.numActa).append("=? AND ");
			strSql.append(W83bActasBD.anyoActa).append("=? AND ");
			strSql.append(W83bActasBD.codTerritActa).append("=?");
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(preaviso.getIdioma()));
			params.add(preaviso.getNum_acta());
			params.add(preaviso.getAnyo_acta());
			params.add(preaviso.getCodTerritorio());
			
			List resultado = W83bDataBase.executeQuery(strSql.toString(),params,null);
			
			if(resultado.size()>0){
				Object numReg = ((HashMap)resultado.get(0)).get(W83bActasBD.numRegDefinitivo);
				Object fecReg = ((HashMap)resultado.get(0)).get(W83bActasBD.fecRegDefinitivo);
				
				preaviso.setNumRegDefinitivoActa(numReg==null?"":numReg.toString());
				preaviso.setFechaRegDefinitivoActa(fecReg==null?"":fecReg.toString());
			}
			
		return preaviso;
	}

	public W83bPreavisosBean obtenerDatosBasicosPreaviso(String codSelec,String idioma)
			throws Exception {
		String [] codPreaviso=codSelec.split("_");
		
		// TODO Auto-generated method stub
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("SELECT ");
		strSql.append(W83bPreavisosBD.num_preaviso_completo).append(", ");
		strSql.append(W83bPreavisosBD.cod_territorio).append(", ");
		strSql.append(W83bPreavisosBD.cod_municipio).append(", ");
		strSql.append(W83bPreavisosBD.codPostal).append(", ");
		strSql.append(W83bPreavisosBD.domicilio).append(", ");
		strSql.append(W83bPreavisosBD.localidad).append(", ");
		strSql.append(W83bPreavisosBD.anyo_eleccion).append(", ");
		strSql.append(W83bPreavisosBD.num_preaviso).append(", ");
		strSql.append(W83bPreavisosBD.numpreavisosencilloentero).append(", ");
		strSql.append(W83bPreavisosBD.fecha_entrada).append(", ");
		strSql.append(W83bPreavisosBD.fecha_inicio).append(", ");
		strSql.append(W83bPreavisosBD.fecha_eleccion).append(", ");
		strSql.append(W83bPreavisosBD.num_registro).append(", ");
		strSql.append(W83bPreavisosBD.fecha_registro).append(", ");
		strSql.append(W83bPreavisosBD.razon_social).append(", ");
		strSql.append(W83bPreavisosBD.id_centrotrabajo).append(", ");
		strSql.append(W83bPreavisosBD.cod_territorio_centro).append(", ");
		strSql.append(W83bPreavisosBD.cif).append(", ");
		strSql.append(W83bPreavisosBD.num_centro).append(", ");
		strSql.append(W83bPreavisosBD.num_trabajadores).append(", ");
		strSql.append(W83bPreavisosBD.eleccion_parcial).append(", ");
		strSql.append(W83bPreavisosBD.preaviso_global).append(", ");
		strSql.append(W83bPreavisosBD.cod_convenio).append(", ");
		strSql.append(W83bPreavisosBD.admon_empresa).append(", ");
		strSql.append(W83bPreavisosBD.num_centros_afectados).append(", ");
		strSql.append(W83bPreavisosBD.num_acta).append(", ");
		strSql.append(W83bPreavisosBD.observaciones).append(", ");
		strSql.append(W83bPreavisosBD.anyo_acta).append(", ");
		strSql.append(W83bPreavisosBD.dirAlternativa).append(", ");
		strSql.append(W83bPreavisosBD.codPostalalternativa).append(", ");
		strSql.append(W83bPreavisosBD.idProvincia_alt).append(", ");
		strSql.append(W83bPreavisosBD.codMunicipio_alt).append(", ");
		strSql.append(W83bPreavisosBD.cods_promotores).append(", ");
		strSql.append(W83bPreavisosBD.tipoPreaviso).append(", ");
		
		if (idioma.equals(W83bClsConstantes.CONSTANTE_CASTELLANO))
		{
			strSql.append(W83bPreavisosBD.desc_promotores).append(" AS ").append(W83bPreavisosBD.desc_promotores).append(", ");

		}
		else
		{
			strSql.append(W83bPreavisosBD.dese_promotores).append(" AS ").append(W83bPreavisosBD.desc_promotores).append(", ");

		}
		
		strSql.append("'").append(idioma).append("' as IDIOMA");

		strSql.append(" FROM ").append(W83bPreavisosBD.preavisosView);
		
		strSql.append(" WHERE ").append(W83bPreavisosBD.cod_territorio).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83bPreavisosBD.anyo_eleccion).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83bPreavisosBD.num_preaviso).append(" = ?");
		
		params.add(new String(codPreaviso[0]));		
		params.add(new Integer(codPreaviso[1]));
		params.add(new Integer(codPreaviso[2]));
		
		
		List listaPreavisos = W83bDataBase.executeQuery(strSql.toString(),params,W83bPreavisosBean.class,null, null);
		((W83bPreavisosBean)listaPreavisos.get(0)).setCodSelec(codSelec);
	
		return ((W83bPreavisosBean)listaPreavisos.get(0));
	}

	public W83bPreavisosBean obtenerPreavisoOriginal(String codSelec,String idioma)throws Exception {

		String [] codPreaviso=codSelec.split("_");

		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("SELECT ");
		strSql.append(W83bPreavisosBD.num_preaviso_completo).append(", ");
		strSql.append(W83bPreavisosBD.cod_territorio).append(", ");
		strSql.append(W83bPreavisosBD.anyo_eleccion).append(", ");
		strSql.append(W83bPreavisosBD.num_preaviso).append(", ");
		strSql.append(W83bPreavisosBD.fecha_inicio).append(", ");
		strSql.append(W83bPreavisosBD.fecha_eleccion).append(", ");
		strSql.append(W83bPreavisosBD.razon_social).append(", ");
		strSql.append(W83bPreavisosBD.cif).append(", ");
		strSql.append(W83bPreavisosBD.num_centro).append(", ");
		strSql.append(W83bPreavisosBD.eleccion_parcial).append(", ");
		strSql.append(W83bPreavisosBD.preaviso_global).append(", ");
		strSql.append(W83bPreavisosBD.cod_convenio).append(", ");
		if (idioma.equals(W83bClsConstantes.CONSTANTE_CASTELLANO))
		{
			strSql.append(W83bPreavisosBD.desc_convenio).append(" AS ").append(W83bPreavisosBD.descripcion_convenio).append(", ");

		}
		else
		{
			strSql.append(W83bPreavisosBD.dese_convenio).append(" AS ").append(W83bPreavisosBD.descripcion_convenio).append(", ");

		}
		strSql.append(W83bPreavisosBD.admon_empresa).append(", ");
		strSql.append(W83bPreavisosBD.num_centros_afectados).append(", ");
	
		strSql.append(W83bPreavisosBD.observaciones).append(", ");
		strSql.append(W83bPreavisosBD.dirAlternativa).append(", ");
		strSql.append(W83bPreavisosBD.codPostalalternativa).append(", ");
		strSql.append(W83bPreavisosBD.idProvincia_alt).append(", ");
		strSql.append(W83bPreavisosBD.codMunicipio_alt).append(", ");
		//29082017-> Ampliacin de campos en preaviso original
		strSql.append(W83bPreavisosBD.CNAE).append(", ");
		strSql.append("cnae.DESCCNAE").append(", ");
		strSql.append(W83bPreavisosBD.telefono).append(", ");
		strSql.append(W83bPreavisosBD.fax).append(", ");
		strSql.append(W83bPreavisosBD.email).append(", ");
		strSql.append(W83bPreavisosBD.territsegsocialv02).append(", ");
		strSql.append(W83bPreavisosBD.numsegsocialv02).append(", ");
		strSql.append(W83bPreavisosBD.digitcontsegsocial).append(", ");
		strSql.append(W83bPreavisosBD.numtrabv02).append(", ");
		strSql.append(W83bPreavisosBD.numRegistroES).append(", ");
		strSql.append(W83bPreavisosBD.fechaRegistroES).append(", ");

		
		strSql.append(W83bPreavisosBD.cods_promotores).append(", ");
		
		strSql.append("'").append(idioma).append("' as IDIOMA").append(", ");
		if (idioma.equals(W83bClsConstantes.CONSTANTE_CASTELLANO))
		{
			strSql.append(W83bPreavisosBD.desc_promotores).append(" AS ").append(W83bPreavisosBD.desc_promotores);

		}
		else
		{
			strSql.append(W83bPreavisosBD.dese_promotores).append(" AS ").append(W83bPreavisosBD.desc_promotores);

		}

		strSql.append(" FROM ").append(W83bPreavisosBD.preavisosOriginalesView);
		strSql.append(" LEFT OUTER JOIN w83bcnae cnae ON W83B02V00.CNAE = cnae.idcnae ");
		
		strSql.append(" WHERE ").append(W83bPreavisosBD.cod_territorio).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83bPreavisosBD.anyo_eleccion).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83bPreavisosBD.num_preaviso).append(" = ?");
		
		
		params.add(new String(codPreaviso[0]));		
		params.add(new Integer(codPreaviso[1]));
		params.add(new Integer(codPreaviso[2]));
		
		
		List listaPreavisos = W83bDataBase.executeQuery(strSql.toString(),params,W83bPreavisosBean.class,null, null);
		
		if (listaPreavisos.size()>0)
			return (W83bPreavisosBean)listaPreavisos.get(0);
		else
			return new W83bPreavisosBean();
	}

	public W83bPreavisosBean obtenerDocsPreaviso(String codSelec,String idioma) throws Exception {
		String [] codPreaviso=codSelec.split("_");

		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		strSql.append(W83bPreavisosBD.id_docu_038).append(", ");
		strSql.append(W83bPreavisosBD.nomb_docu_038).append(", ");
		strSql.append(W83bPreavisosBD.c_territ_038).append(", ");
		strSql.append(W83bPreavisosBD.ano_preaviso_038).append(", ");
		strSql.append(W83bPreavisosBD.n_preaviso_038).append(", ");
		strSql.append(W83bPreavisosBD.tp_doc_038).append(", ");
		strSql.append(W83bPreavisosBD.desc_cas_069).append(", ");
		strSql.append(W83bPreavisosBD.desc_eus_069).append(", ");
		strSql.append(W83bPreavisosBD.desc_cas_052).append(", ");
		strSql.append(W83bPreavisosBD.desc_eus_052).append(", ");
		strSql.append(W83bPreavisosBD.desc_cas_012).append(", ");
		strSql.append(W83bPreavisosBD.desc_eus_012).append(", ");
		strSql.append(W83bPreavisosBD.num_reg_038).append(", to_char(");
		strSql.append(W83bPreavisosBD.f_reg_038).append(",?) as ").append(W83bPreavisosBD.f_reg_038).append(", ");
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(idioma));
		strSql.append(W83bPreavisosBD.usuario_038).append(", ");
		//Datos de acuses
		strSql.append(W83bPreavisosBD.id_remesa_acuse_038).append(", ");
		strSql.append(W83bPreavisosBD.cod_remesa_acuse_038).append(", ");
		strSql.append(W83bPreavisosBD.id_coleccion_acuse_038).append(", ");
		strSql.append(W83bPreavisosBD.cod_coleccion_acuse_038).append(", ");
		strSql.append(W83bPreavisosBD.id_envio_acuse_038).append(", ");
		strSql.append(W83bPreavisosBD.cod_envio_acuse_038);
		
		strSql.append(" FROM ").append(W83bPreavisosBD.preavisos_docsView);
		
		strSql.append(" WHERE ").append(W83bPreavisosBD.c_territ_038).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83bPreavisosBD.ano_preaviso_038).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83bPreavisosBD.n_preaviso_038).append(" = ?");
		
		params.add(new String(codPreaviso[0]));		
		params.add(new Integer(codPreaviso[1]));
		params.add(new Integer(codPreaviso[2]));
		
		List listaDocumentos = W83bDataBase.executeQuery(strSql.toString(),params,W83bDocBean.class,null, null);
		
		W83bPreavisosBean resultado=new W83bPreavisosBean();
		resultado.setListaDocs(listaDocumentos);
		return resultado;

		
	
	}

	public W83bPreavisosBean obtenerImpugnacionesPreaviso(String codSelec,String columnaOrder,String tipoOrdenacion,String idioma)
			throws Exception {

		String [] codPreaviso=codSelec.split("_");
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		
		strSql.append(W83bPreavisosBD.num_impugnacion_completo).append(", to_char(");
		strSql.append(W83bPreavisosBD.fech_impugnacion).append(",?) as ").append(W83bPreavisosBD.fech_impugnacion).append(", ");
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(idioma));
		if (W83bClsConstantes.CONSTANTE_CASTELLANO.equals(idioma))
		{
			strSql.append(W83bPreavisosBD.desc_sindicatos).append(" AS DESC_SINDICATOS , ");

		}
		else
		{
			strSql.append(W83bPreavisosBD.dese_sindicatos).append(" AS DESC_SINDICATOS, ");

		}
		strSql.append(W83bPreavisosBD.dni_arbitro).append(", upper(");
		strSql.append(W83bPreavisosBD.nombre_arbitro).append(") as ").append(W83bPreavisosBD.nombre_arbitro).append(", ");
		strSql.append(W83bPreavisosBD.num_laudo).append(", ");
		strSql.append(W83bPreavisosBD.num_laudocompleto).append(", ");
		strSql.append(W83bPreavisosBD.num_laudocompletoint).append(", ");
		strSql.append(" to_char(");
		strSql.append(W83bPreavisosBD.fech_laudo).append(",?) as ").append(W83bPreavisosBD.fech_laudo).append(", to_char(");
		strSql.append(W83bPreavisosBD.fech_envio_juzgado).append(",?) as ").append(W83bPreavisosBD.fech_envio_juzgado).append(", to_char(");
		strSql.append(W83bPreavisosBD.fech_sentencia).append(",?) as ").append(W83bPreavisosBD.fech_sentencia).append(", to_char(");
		strSql.append(W83bPreavisosBD.fech_baja_desestimiento).append(",?) as ").append(W83bPreavisosBD.fech_baja_desestimiento).append(", ");
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(idioma));
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(idioma));
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(idioma));
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(idioma));
//		strSql.append(W83bPreavisosBD.resultado).append(", ");
		if (W83bClsConstantes.CONSTANTE_CASTELLANO.equals(idioma))
		{
			strSql.append(W83bPreavisosBD.rdto_cas).append(" AS ").append(W83bPreavisosBD.resultado).append(", ");
			
		}
		else
		{
			strSql.append(W83bPreavisosBD.rdto_eus).append(" AS ").append(W83bPreavisosBD.resultado).append(", ");
			
		}
		
		strSql.append(W83bPreavisosBD.nombreImpugnante).append(", ");
		if (W83bClsConstantes.CONSTANTE_CASTELLANO.equals(idioma))
		{
			strSql.append(W83bPreavisosBD.desc_tipo).append(" AS ").append(W83bPreavisosBD.desc_tipo);
			
		}
		else
		{
			strSql.append(W83bPreavisosBD.dese_tipo).append(" AS ").append(W83bPreavisosBD.desc_tipo);
			
		}

		
		strSql.append(" FROM ").append(W83bPreavisosBD.preaviso_impugnaciones_View);
		
		strSql.append(" WHERE ").append(W83bPreavisosBD.c_territ_nora).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83bPreavisosBD.ano_preaviso_037).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83bPreavisosBD.n_preaviso_037).append(" = ?");
		
		if(StringUtils.isNotEmpty(columnaOrder)
				&&StringUtils.isNotEmpty(tipoOrdenacion)){
			strSql.append(" ORDER BY ").append(columnaOrder).append(" ").append(tipoOrdenacion);
		}
		
		params.add(new String(codPreaviso[0]));		
		params.add(new Integer(codPreaviso[1]));
		params.add(new Integer(codPreaviso[2]));
		
		List listaImpugnaciones = W83bDataBase.executeQuery(strSql.toString(),params,W83bImpugnacionesBean.class,null, "");
		
		W83bPreavisosBean resultado=new W83bPreavisosBean();
		resultado.setListaImpugnaciones(listaImpugnaciones);
		return resultado;

	}

	public W83bPreavisosBean obtenerHistorialPreaviso(String codSelec,String columnaOrder,String tipoOrdenacion,String strIdioma)
			throws Exception {
		
		String [] codPreaviso=codSelec.split("_");
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		
		strSql.append(W83bPreavisosBD.factu_055).append(", ");
		
		//TODO cambiar a que llegue el idioma
		if(W83bClsConstantes.CONSTANTE_CASTELLANO.equals(strIdioma)){
			strSql.append(W83bPreavisosBD.desc_cas_055).append(" AS DESCRIPCION , ");
		}else{
			strSql.append(W83bPreavisosBD.dese_cas_055).append(" AS DESCRIPCION , ");			
		}

		strSql.append(W83bPreavisosBD.usua_055);

		
		strSql.append(" FROM ").append(W83bPreavisosBD.preaviso_historial_Synonym);
		
		strSql.append(" WHERE ").append(W83bPreavisosBD.c_territ_055).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83bPreavisosBD.ano_preaviso_055).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83bPreavisosBD.n_preaviso_055).append(" = ?");
		
		
	
			strSql.append(" ORDER BY ").append(" ").append(W83bPreavisosBD.factu_055).append(" desc ");			
		
		params.add(new String(codPreaviso[0]));		
		params.add(new Integer(codPreaviso[1]));
		params.add(new Integer(codPreaviso[2]));
		
		List listaHistorial = W83bDataBase.executeQuery(strSql.toString(),params,W83bHistorialPreavisoBean.class,null, strIdioma);
		
		W83bPreavisosBean resultado=new W83bPreavisosBean();
		resultado.setListaHistorial(listaHistorial);
		return resultado;	
		
	}

	public W83bPreavisosBean obtenerTramitesPreaviso(String codSelec,String idioma,String columnaOrder,String tipoOrdenacion,String strIdioma)
			throws Exception {
				
		String [] codPreaviso=codSelec.split("_");
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		
		strSql.append(W83bPreavisosBD.cod_fase).append(", ");
		if(W83bClsConstantes.CONSTANTE_CASTELLANO.equals(strIdioma)){
			strSql.append(W83bPreavisosBD.desc_fase).append (" AS DESC_FASE");
		}else{
			strSql.append(W83bPreavisosBD.dese_fase).append (" AS DESC_FASE");			
		}
		strSql.append(", ");
		if(W83bClsConstantes.CONSTANTE_CASTELLANO.equals(strIdioma)){
			strSql.append(W83bPreavisosBD.desc_tramite).append (" AS DESC_TRAMITE");
		}else{
			strSql.append(W83bPreavisosBD.dese_tramite).append (" AS DESC_TRAMITE");			
		}
		strSql.append(", TO_CHAR(");
		strSql.append(W83bPreavisosBD.f_actu_tramite).append(",?) AS ").append(W83bPreavisosBD.f_actu_tramite).append(",");
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(idioma));
		strSql.append(W83bPreavisosBD.usu_alta).append(", TO_CHAR(");
		strSql.append(W83bPreavisosBD.fecha_alta_tramite).append(",?) AS ").append(W83bPreavisosBD.fecha_alta_tramite).append(",");
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(idioma));
		strSql.append(W83bPreavisosBD.usu_mod).append(", TO_CHAR(");
		strSql.append(W83bPreavisosBD.fecha_mod).append(",?) AS ").append(W83bPreavisosBD.fecha_mod).append(", TO_CHAR(");
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(idioma));
		strSql.append(W83bPreavisosBD.fecha_reg_salida).append(",?) AS ").append(W83bPreavisosBD.fecha_reg_salida).append(", ");
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(idioma));
		strSql.append(W83bPreavisosBD.num_reg_salid);

		
		strSql.append(" FROM ").append(W83bPreavisosBD.vista_historial_tramitacion);
		
		strSql.append(" WHERE ").append(W83bPreavisosBD.cod_territorio).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83bPreavisosBD.ano_preaviso).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83bPreavisosBD.num_preaviso).append(" = ?");
		
		

			strSql.append(" ORDER BY ").append(" ").append(W83bPreavisosBD.cod_tramite).append(" asc ");			

		
		params.add(new String(codPreaviso[0]));		
		params.add(new Integer(codPreaviso[1]));
		params.add(new Integer(codPreaviso[2]));
		
		List listaTramites = W83bDataBase.executeQuery(strSql.toString(),params,W83bTramitePreavisoBean.class,null, null);
			
		W83bPreavisosBean resultado=new W83bPreavisosBean();
		resultado.setListaTramites(listaTramites);
		return resultado;
	}

	public void borrarPromotoresPreavisos(W83bPreavisosBean param)
			throws Exception {
		String [] codPreaviso=param.getCodSelec().split("_");

		if (StringUtils.isNotEmpty(param.getCodsPromotoresBorrados()))
		{
			StringBuffer strSql = new StringBuffer();
			List params = new ArrayList();
			
			strSql.append("DELETE FROM ");
			strSql.append(W83bPreavisosBD.preavisos_sindicatos_table);
			strSql.append(" WHERE ");
			strSql.append(W83bPreavisosBD.n_preaviso_027).append(" = ?");
			strSql.append(" AND ");
			strSql.append(W83bPreavisosBD.ano_preaviso_027).append(" = ?");
			strSql.append(" AND ");
			strSql.append(W83bPreavisosBD.c_territ_027).append(" = ?");
			strSql.append(" AND ");
			strSql.append(W83bPreavisosBD.c_sindi_027).append(" = ?");

			String [] codsPromotoresBorrados=param.getCodsPromotoresBorrados().split(",");
			
			for (int i=0;i<codsPromotoresBorrados.length;i++)
			{
				params.add(codPreaviso[2]);
				params.add(codPreaviso[1]);
				params.add(codPreaviso[0]);
				params.add(codsPromotoresBorrados[i]);
				
				W83bDataBase.executeTableMovement(strSql.toString(), params,param.getUsuarioBean());
				params.clear();
			}
		}
		
	}

	public W83bDocBean descargarDocumento(String param) throws Exception {
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		strSql.append(W83bPreavisosBD.nomb_docu_038).append(",");
		strSql.append(W83bPreavisosBD.long_docu_038).append(",");
		strSql.append(W83bPreavisosBD.docu_038);
		strSql.append(" FROM ").append(W83bPreavisosBD.preavisos_docsTable);
		//TODO cambiar por id_doc_037
		strSql.append(" WHERE ").append(W83bPreavisosBD.id_docu_038).append(" = ?");
		
		params.add(param);		
		
		List listaDocumentos = W83bDataBase.executeQuery(strSql.toString(),params,W83bDocBean.class,null, null);
		
		if (listaDocumentos.size()>0)
			return (W83bDocBean)listaDocumentos.get(0);
		else
			throw new Exception("No existe ese documento");

		

	}

	public void anyadirHistorialTramitacion(W83bPreavisosBean param,String fase, String tramite,String fechaRegistro)
			throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		strSql.append("INSERT INTO ");
		strSql.append(W83bPreavisosBD.historial_tramitacion_Synonym);
		
		strSql.append("(");
		strSql.append(W83bPreavisosBD.n_preaviso_056);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.ano_preaviso_056);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.c_territ_056);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.c_tram_056);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.c_fase_056);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.f_actu_056);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.usua_056);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.usu_mod_056);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.f_modif_056);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.f_tram_056);
		strSql.append(")");
		
		strSql.append(" VALUES (?,?,?,?,?,to_date(?,'"+W83bClsConstantes.FORMATO_FECHA_CASTELLANO+"'),?,?,");
//		strSql.append("to_date(?,'"+W83bClsConstantes.FORMATO_FECHA_CASTELLANO+"'),");
		strSql.append("?,");
		strSql.append("to_date(?,'"+W83bClsConstantes.FORMATO_FECHA_COMPLETA_CASTELLANO+"'))");
		
		params.add(new Integer(param.getNum_preaviso()));
		params.add(new Integer(param.getAnyoPreaviso()));
		params.add(param.getCodTerritorio());

		params.add(new Integer(tramite));
		params.add(new Integer(fase));
		SimpleDateFormat sdf =new SimpleDateFormat(W83bDateUtil.ES_PATTERN);
		params.add(sdf.format(new Date()));
		params.add(param.getUsuarioBean().getIdUsuario());
//		params.add(param.getUsuarioBean().getIdUsuario());
		params.add(W83bClsConstantes.NULL_STRING);
//		params.add(sdf.format(new Date()));
		params.add(W83bClsConstantes.NULL_DATE);
		
		W83bClsTrazas.trazaDebug(null, "fechaRegistro::" +fechaRegistro);
		if ("1".equals(param.getUsuarioBean().getRegManual()))
		{
			if(StringUtils.isNotEmpty(fechaRegistro)){
				params.add(fechaRegistro);							
			}else{
				SimpleDateFormat hoy =new SimpleDateFormat(W83bClsConstantes.FORMATO_FECHA_CASTELLANO_PARSER);
				params.add(hoy.format(new Date()));					
			}
								
		}
		else
		{
			SimpleDateFormat hoy =new SimpleDateFormat(W83bClsConstantes.FORMATO_FECHA_CASTELLANO_PARSER);
			params.add(hoy.format(new Date()));		
		}	
		
		
		/*if(StringUtils.isNotEmpty(fechaRegistro)){
			params.add(fechaRegistro);
		}
		else{
			SimpleDateFormat hoy =new SimpleDateFormat(W83bClsConstantes.FORMATO_FECHA_CASTELLANO_PARSER);
			params.add(hoy.format(new Date()));
		}*/
		W83bDataBase.executeTableMovement(strSql.toString(), params,param.getUsuarioBean());
		
	}
	
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIImpugnacionesDAO#anyadirTramite(w83b.w83bBeans.W83bImpugnacionBean)
	 */
	
	public void editarTramite(W83bPreavisosBean param, int fase, int tramite) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		
		params= new ArrayList();
		strSql.append("UPDATE ");
		strSql.append(W83bPreavisosBD.historial_tramitacion_Synonym);
		strSql.append (" SET ");
		
		strSql.append(W83bPreavisosBD.f_modif_056);
		strSql.append(" = to_date(?,'"+W83bDateUtil.ES_PATTERN_HORA_INSERT+"')");
		strSql.append(", ");
		strSql.append(W83bPreavisosBD.usu_mod_056);
		strSql.append(" = ?");
		strSql.append(" WHERE ");
		strSql.append(W83bPreavisosBD.n_preaviso_056);
		strSql.append(" = ? ");
		strSql.append(" AND ");
		strSql.append(W83bPreavisosBD.c_territ_056);
		strSql.append(" = ? ");
		strSql.append(" AND ");
		strSql.append(W83bPreavisosBD.ano_preaviso_056);
		strSql.append(" = ? ");
		strSql.append(" AND ");
		strSql.append(W83bPreavisosBD.c_fase_056);
		strSql.append(" = ? ");
		strSql.append(" AND ");
		strSql.append(W83bPreavisosBD.c_tram_056);
		strSql.append(" = ? ");
		
		SimpleDateFormat sdf =new SimpleDateFormat(W83bDateUtil.ES_PATTERN_HORA);
		params.add(sdf.format(new Date()));
		params.add(param.getUsuarioBean().getIdUsuario().toUpperCase());
		params.add(new Integer(param.getNum_preaviso()));
		params.add(param.getCodTerritorio().toUpperCase());
		params.add(new Integer(param.getAnyoPreaviso()));
		params.add(new Integer(fase));
		params.add(new Integer(tramite));
		
		W83bDataBase.executeTableMovement(strSql.toString(), params,param.getUsuarioBean());		
	}

	public void anyadirPromotoresOriginal(W83bPreavisosBean param)
			throws Exception {
		// TODO Auto-generated method stub
		StringBuffer strSql = new StringBuffer();
		List params = new ArrayList();		
		String[] codsPromotores = null;
		if (StringUtils.isNotEmpty(param.getCodsPromotores()))
		{
			codsPromotores= param.getCodsPromotores().split(",");	
			strSql= new StringBuffer();
			params= new ArrayList();
			strSql.append("INSERT INTO ").append(W83bPreavisosBD.preaviso_original_sindicatos_table);
			strSql.append ("(").append(W83bPreavisosBD.n_preaviso_054);
			strSql.append(",").append(W83bPreavisosBD.ano_preaviso_054);
			strSql.append(",").append(W83bPreavisosBD.c_territ_054);
			strSql.append(",").append(W83bPreavisosBD.c_sindi_054).append(")");
			strSql.append(" VALUES (?,?,?,?)");
			params.add(new Integer(param.getNum_preaviso()));
			params.add(new Integer(param.getAnyoPreaviso()));
			params.add(param.getCodTerritorio().toUpperCase());

			for (int i=0;i<codsPromotores.length;i++)
			{
				params.add(codsPromotores[i]);
				W83bDataBase.executeTableMovement(strSql.toString(), params,param.getUsuarioBean());
				params.remove(params.size()-1);
			}
			

		}
		
	}
	
	public void borrarDocsPreavisos(W83bPreavisosBean param)
	throws Exception {
		if (param.getListaDocsBorrados()!=null && param.getListaDocsBorrados().size()>0)
		{
			StringBuffer strSql = new StringBuffer();
			List params = new ArrayList();
			
			strSql.append("DELETE FROM ");
			strSql.append(W83bPreavisosBD.preavisos_docsTable);
			strSql.append(" WHERE ");
			strSql.append(W83bPreavisosBD.id_docu_038).append(" = ?");
			
			for (int i=0;i< param.getListaDocsBorrados().size();i++)
			{
				String idDoc= (String)param.getListaDocsBorrados().get(i);
				params.add(idDoc);
				W83bDataBase.executeTableMovement(strSql.toString(), params,param.getUsuarioBean());
				params.clear();
			}
		}
	}

	public void borrarPromotoresPreavisosOriginal(W83bPreavisosBean param)
			throws Exception {
		
		String [] codPreaviso=param.getCodSelec().split("_");

		if (StringUtils.isNotEmpty(param.getCodsPromotoresBorrados()))
		{
			StringBuffer strSql = new StringBuffer();
			List params = new ArrayList();
			
			strSql.append("DELETE FROM ");
			strSql.append(W83bPreavisosBD.preaviso_original_sindicatos_table);
			strSql.append(" WHERE ");
			strSql.append(W83bPreavisosBD.n_preaviso_054).append(" = ?");
			strSql.append(" AND ");
			strSql.append(W83bPreavisosBD.ano_preaviso_054).append(" = ?");
			strSql.append(" AND ");
			strSql.append(W83bPreavisosBD.c_territ_054).append(" = ?");
			strSql.append(" AND ");
			strSql.append(W83bPreavisosBD.c_sindi_054).append(" = ?");

			String [] codsPromotoresBorrados=param.getCodsPromotoresBorrados().split(",");
			
			for (int i=0;i<codsPromotoresBorrados.length;i++)
			{
				params.add(codPreaviso[2]);
				params.add(codPreaviso[1]);
				params.add(codPreaviso[0]);
				params.add(codsPromotoresBorrados[i]);
				
				W83bDataBase.executeTableMovement(strSql.toString(), params,param.getUsuarioBean());
				params.clear();
			}
		}
	}

	public void editarPreavisosOriginal(W83bPreavisosBean param)
			throws Exception {
		String [] codPreaviso=param.getCodSelec().split("_");

		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		strSql.append("UPDATE ");
		strSql.append(W83bPreavisosBD.preavisos_originalesTable);
		strSql.append(" SET ");
		if (StringUtils.isNotEmpty(param.getFecha_inicio())){
			strSql.append(W83bPreavisosBD.f_inicio_053);
			strSql.append(" = to_date(?,?)");
		}else{
			strSql.append(W83bPreavisosBD.f_inicio_053);
			strSql.append(" = ?");			
		}
		strSql.append(",");
		if (StringUtils.isNotEmpty(param.getFecha_eleccion())){
			strSql.append(W83bPreavisosBD.f_elecc_053);
			strSql.append(" = to_date(?,?)");
		}else{
			strSql.append(W83bPreavisosBD.f_elecc_053);
			strSql.append(" = ?");			
		}
		strSql.append(",");
		strSql.append(W83bPreavisosBD.s_parcial_053);
		strSql.append(" = ?");
		strSql.append(",");
		strSql.append(W83bPreavisosBD.global_053);
		strSql.append(" = ?");
		strSql.append(",");
		strSql.append(W83bPreavisosBD.observ_053);
		strSql.append(" = ?");
		strSql.append(",");
		strSql.append(W83bPreavisosBD.usua_053);
		strSql.append(" = ?");
		strSql.append(",");
			strSql.append(W83bPreavisosBD.factu_053);
			strSql.append(" = SYSDATE ");
		strSql.append(",");
		strSql.append(W83bPreavisosBD.convacu_053);
		strSql.append(" = ?");
		strSql.append(",");
		strSql.append(W83bPreavisosBD.admonemp_053);
		strSql.append(" = ?");
		strSql.append(",");
		strSql.append(W83bPreavisosBD.n_cenafec_053);
		strSql.append(" = ?");
		strSql.append(",");
		strSql.append(W83bPreavisosBD.fenvio_053);
		strSql.append(" = ?");
		strSql.append(",");
		strSql.append(W83bPreavisosBD.usuenv_053);
		strSql.append(" = ?");
		strSql.append(",");
		strSql.append(W83bPreavisosBD.ncarprocelec_053);
		strSql.append(" = ?");
		strSql.append(",");
		strSql.append(W83bPreavisosBD.oid8501_053);
		strSql.append(" = ?");
		strSql.append(",");
		strSql.append(W83bPreavisosBD.nop_053);
		strSql.append(" = ?");
		strSql.append(",");
		strSql.append(W83bPreavisosBD.ndf_053);
		strSql.append(" = ?");
		strSql.append(",");
		strSql.append(W83bPreavisosBD.c_conv_053);
		strSql.append(" = ?");
		strSql.append(",");		
		strSql.append(W83bPreavisosBD.dir_alt_053);
		strSql.append(" = ?");
		strSql.append(",");
		strSql.append(W83bPreavisosBD.codPos_alt_053);
		strSql.append(" = ?");
		strSql.append(",");
		strSql.append(W83bPreavisosBD.mun_alt_053);
		strSql.append(" = ?");
		strSql.append(",");
		strSql.append(W83bPreavisosBD.prov_alt_053);
		strSql.append(" = ?");
		strSql.append(",");
		strSql.append(W83bPreavisosBD.nif_centro_053);
		strSql.append(" = ?");
		strSql.append(",");
		strSql.append(W83bPreavisosBD.num_centro_053);
		strSql.append(" = ?");
		strSql.append(",");
		strSql.append(W83bPreavisosBD.raz_social_053);
		strSql.append(" = ?");
		//Campos nuevos aadidos 27082017
		strSql.append(",");
		strSql.append(W83bPreavisosBD.cnae_053);
		strSql.append(" = ?");	
		strSql.append(",");
		strSql.append(W83bPreavisosBD.email_053);
		strSql.append(" = ?");			
		strSql.append(",");
		strSql.append(W83bPreavisosBD.fax_053);
		strSql.append(" = ?");		
		strSql.append(",");
		strSql.append(W83bPreavisosBD.telefono_053);
		strSql.append(" = ?");		
		strSql.append(",");
		strSql.append(W83bPreavisosBD.n_trabaj_053);
		strSql.append(" = ?");
		strSql.append(",");
		strSql.append(W83bPreavisosBD.th_ss_053);
		strSql.append(" = ?");
		strSql.append(",");
		strSql.append(W83bPreavisosBD.n_ss_053);
		strSql.append(" = ?");
		strSql.append(",");
		strSql.append(W83bPreavisosBD.ctrl_ss_053);
		strSql.append(" = ?");
		strSql.append(",");
		if (StringUtils.isNotEmpty(param.getFechaRegistroESPreavisoOriginal())){
			strSql.append(W83bPreavisosBD.f_regis_053);
			strSql.append(" = to_date(?,?)");
		}else{
			strSql.append(W83bPreavisosBD.f_regis_053);
			strSql.append(" = ?");			
		}
		strSql.append(",");
		strSql.append(W83bPreavisosBD.n_regis_053);
		strSql.append(" = ?");
		
		
		
		strSql.append(" WHERE ").append(W83bPreavisosBD.ano_preaviso_053).append(" = ? ");
		strSql.append(" AND ").append(W83bPreavisosBD.n_preaviso_053).append(" = ? ");
		strSql.append(" AND ").append(W83bPreavisosBD.c_territ_053).append(" = ? ");
		
		if (StringUtils.isNotEmpty(param.getFecha_inicio())){
			params.add(param.getFecha_inicio());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}else{
			params.add(W83bClsConstantes.NULL_DATE);			
		}
		if (StringUtils.isNotEmpty(param.getFecha_eleccion())){
			params.add(param.getFecha_eleccion());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}else{
			params.add(W83bClsConstantes.NULL_DATE);			
		}
		
		if (StringUtils.isNotEmpty(param.getEleccion_parcial())){
			params.add(param.getEleccion_parcial());
		}else{
			params.add("N");
		}
		if (StringUtils.isNotEmpty(param.getPreaviso_global())){
			params.add(param.getPreaviso_global());
		}else{
			params.add("N");
		}
		if (StringUtils.isNotEmpty(param.getObservaciones())){
			params.add(param.getObservaciones());
		}else{
			params.add(W83bClsConstantes.NULL_STRING);
		}
		//USUA??
		params.add(param.getUsuarioBean().getIdUsuario());
		//FACTU_037??

		params.add(W83bClsConstantes.NULL_INTEGER);

		if (StringUtils.isNotEmpty(param.getAdmon())){
			params.add(param.getAdmon());

		}else{
				params.add("N");
			}
		if (StringUtils.isNotEmpty(param.getNum_centros_afectados())){
			params.add(new Integer(param.getNum_centros_afectados()));
		}else{
			params.add(W83bClsConstantes.NULL_INTEGER);
		}
		//FENVIO??
		params.add(W83bClsConstantes.NULL_DATE);
		//USUENV??
		//TODO cambiar a usuario xlnets
		params.add(param.getUsuarioBean().getIdUsuario());
		//ncarpprocelec??
		params.add(W83bClsConstantes.NULL_INTEGER);
		//OID??
		params.add(W83bClsConstantes.NULL_INTEGER);
		//NOP??
		params.add(W83bClsConstantes.NULL_INTEGER);
		//NDF??
		params.add(W83bClsConstantes.NULL_STRING);
		if (StringUtils.isNotEmpty(param.getCodConvenio())){
			params.add(param.getCodConvenio());
		}else{
			params.add(W83bClsConstantes.NULL_STRING);
		}
		
		
		if (StringUtils.isNotEmpty(param.getDirAlternativa())){
			params.add(param.getDirAlternativa());
		}
		else{
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if (StringUtils.isNotEmpty(param.getCodPostalAlternativa())){
			params.add(param.getCodPostalAlternativa());
		}
		else{
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if (StringUtils.isNotEmpty(param.getCodMunicipio_alt())){
			params.add(param.getCodMunicipio_alt());
		}
		else{
			params.add(W83bClsConstantes.NULL_STRING);
		}
		
		if (StringUtils.isNotEmpty(param.getIdProvincia_alt())){
			params.add(param.getIdProvincia_alt());
		}
		else{
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if (StringUtils.isNotEmpty(param.getCentroTrabajo().getCifnif())){
			params.add(param.getCentroTrabajo().getCifnif().toUpperCase());
		}
		else{
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if (StringUtils.isNotEmpty(param.getCentroTrabajo().getNumCentro())){
			params.add(new Integer(param.getCentroTrabajo().getNumCentro()));
		}
		else{
			params.add(W83bClsConstantes.NULL_INTEGER);
		}
		if (StringUtils.isNotEmpty(param.getCentroTrabajo().getRazonSocial())){
			params.add(param.getCentroTrabajo().getRazonSocial());
		}
		else{
			params.add(W83bClsConstantes.NULL_STRING);
		}
		
		if (StringUtils.isNotEmpty(param.getCnaePreavisoOriginal())){
			params.add(param.getCnaePreavisoOriginal());
		}
		else{
			params.add(W83bClsConstantes.NULL_STRING);
		}
		
		if (StringUtils.isNotEmpty(param.getEmailPreavisoOriginal())){
			params.add(param.getEmailPreavisoOriginal());
		}
		else{
			params.add(W83bClsConstantes.NULL_STRING);
		}
		
		if (StringUtils.isNotEmpty(param.getFaxPreavisoOriginal())){
			params.add(param.getFaxPreavisoOriginal());
		}
		else{
			params.add(W83bClsConstantes.NULL_STRING);
		}
		
		if (StringUtils.isNotEmpty(param.getTelefonoPreavisoOriginal())){
			params.add(param.getTelefonoPreavisoOriginal());
		}
		else{
			params.add(W83bClsConstantes.NULL_STRING);
		}
		
		if (StringUtils.isNotEmpty(param.getNumtrab())){
			params.add(param.getNumtrab());
		}
		else{
			params.add(W83bClsConstantes.NULL_STRING);
		}
		
		if (StringUtils.isNotEmpty(param.getTerritsegsocial())){
			params.add(param.getTerritsegsocial());
		}
		else{
			params.add(W83bClsConstantes.NULL_STRING);
		}
		
		if (StringUtils.isNotEmpty(param.getNumsegsocial())){
			params.add(param.getNumsegsocial());
		}
		else{
			params.add(W83bClsConstantes.NULL_STRING);
		}
		
		if (StringUtils.isNotEmpty(param.getDigcontsegsocial())){
			params.add(param.getDigcontsegsocial());
		}
		else{
			params.add(W83bClsConstantes.NULL_STRING);
		}
		
		if (StringUtils.isNotEmpty(param.getFechaRegistroESPreavisoOriginal())){
			params.add(param.getFechaRegistroESPreavisoOriginal());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}else{
			params.add(W83bClsConstantes.NULL_DATE);			
		}
		
		if (StringUtils.isNotEmpty(param.getNumRegistroESPreavisoOriginal())){
			params.add(param.getNumRegistroESPreavisoOriginal());
		}
		else{
			params.add(W83bClsConstantes.NULL_STRING);
		}
		
		params.add(new String(codPreaviso[1]));		
		params.add(new Integer(codPreaviso[2]));
		params.add(new Integer(codPreaviso[0]));

		
		W83bDataBase.executeTableMovement(strSql.toString(), params,param.getUsuarioBean());
		
	}
	
	/**
	 * Existe amite.
	 * 
	 * @param param the param
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean existeTramite(W83bPreavisosBean param,int fase, int tramite)
	throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT * FROM ").append( W83bPreavisosBD.historial_tramitacion_Synonym);
		
		
		strSql.append(" WHERE ").append(W83bPreavisosBD.ano_preaviso_056).append(" = ? ");
		strSql.append(" AND ").append(W83bPreavisosBD.n_preaviso_056).append(" = ? ");
		strSql.append(" AND ").append(W83bPreavisosBD.c_territ_056).append(" = ? ");
		strSql.append(" AND ").append(W83bPreavisosBD.c_fase_056).append(" = ? ");
		strSql.append(" AND ").append(W83bPreavisosBD.c_tram_056).append(" = ? ");
		params.add(new Integer(param.getAnyoPreaviso()));		
		params.add(new Integer(param.getNumPreaviso()));
		params.add(param.getCodTerritorio());
		params.add(new Integer(fase));		
		params.add(new Integer(tramite));
		
		
		List lista = W83bDataBase.executeSimpleQuery(strSql.toString(),params,null);
		
		if(lista.size()>0){
			return true;
		}
		
		return false;
	}
	
	public List buscaHistorialTramitacionPreavisos(W83bPreavisosBean param,String fase,String tramite){
		
		String [] codPreaviso=param.getCodSelec().split("_");
		
		List listaFasesTramites=new ArrayList();
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		strSql.append(W83bPreavisosBD.c_fase_056);
		strSql.append(",");
		strSql.append(W83bPreavisosBD.c_tram_056);
		strSql.append(" FROM ");
		strSql.append(W83bPreavisosBD.historial_tramitacion_Synonym);
		strSql.append(" WHERE ");
		strSql.append(W83bPreavisosBD.n_preaviso_056).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83bPreavisosBD.ano_preaviso_056).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83bPreavisosBD.c_territ_056).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83bPreavisosBD.c_fase_056).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83bPreavisosBD.c_tram_056).append(" = ?");
		
		params.add(new Integer(codPreaviso[2]));
		params.add(new Integer(codPreaviso[1]));
		params.add(codPreaviso[0]);
		params.add(fase);
		params.add(tramite);
		
		try {
			listaFasesTramites=W83bDataBase.executeQuery(strSql.toString(),params,W83bDatosFasesTramitesBean.class,null, null);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			W83bClsTrazas.trazaError(null, e.getLocalizedMessage(), e);
		}
		return listaFasesTramites;
	}

	public List cargaTiposDocumento(HashMap param) throws Exception {
		List listaFasesTramites=new ArrayList();
		StringBuffer strSql = new StringBuffer();
		List params = new ArrayList();
		if (param.get("numPreaviso")!=null)
		{

			W83bDatosFasesTramitesBean datos=new W83bDatosFasesTramitesBean();
			datos.setCodFase(W83bClsConstantes.FASE_TRAMITACION_PREAVISO);
			datos.setCodTramite(W83bClsConstantes.TRAMITE_RECEPCION_SOLICITUD);
			listaFasesTramites.add(datos);
			datos=new W83bDatosFasesTramitesBean();
			datos.setCodFase(W83bClsConstantes.FASE_TRAMITACION_PREAVISO);
			datos.setCodTramite(W83bClsConstantes.TRAMITE_SINESPECIFICAR);
			listaFasesTramites.add(datos);
		}else{
			W83bDatosFasesTramitesBean datos=new W83bDatosFasesTramitesBean();
			datos.setCodFase(W83bClsConstantes.FASE_TRAMITACION_PREAVISO);
			datos.setCodTramite(W83bClsConstantes.TRAMITE_RECEPCION_PREAVISO_E_INICIACION_EXPED);
			listaFasesTramites.add(datos);
			datos=new W83bDatosFasesTramitesBean();
			datos.setCodFase(W83bClsConstantes.FASE_TRAMITACION_PREAVISO);
			datos.setCodTramite(W83bClsConstantes.TRAMITE_SINESPECIFICAR);
			listaFasesTramites.add(datos);
		}
		//obtengo los documentos
		strSql = new StringBuffer();
		params = new ArrayList();
		strSql.append("SELECT ");
		strSql.append(W83bTiposDocumentosVistaBD.tipoDocFasTram);
		strSql.append(",");
		strSql.append(W83bTiposDocumentosVistaBD.fase);
		strSql.append(",");
		strSql.append(W83bTiposDocumentosVistaBD.tramite);
		strSql.append(",");
		if (W83bClsConstantes.CONSTANTE_CASTELLANO.equals(param.get("strIdioma"))){
			strSql.append(W83bTiposDocumentosVistaBD.descFase).append(" AS DESCFASE , ");
			strSql.append(W83bTiposDocumentosVistaBD.descTramite).append(" AS DESCTRAMITE, ");
			strSql.append(W83bTiposDocumentosVistaBD.descTipoDoc).append(" AS DESCRIPCION ");
		}else{
			strSql.append(W83bTiposDocumentosVistaBD.deseFase).append(" AS DESCFASE , ");
			strSql.append(W83bTiposDocumentosVistaBD.deseTramite).append(" AS DESCTRAMITE, ");
			strSql.append(W83bTiposDocumentosVistaBD.deseTipoDoc).append(" AS DESCRIPCION ");
		}
		strSql.append(" FROM ");
		strSql.append(W83bTiposDocumentosVistaBD.vista);
		strSql.append(" WHERE ");
		//strSql.append(W83bTiposDocumentosVistaBD.tramite).append(" = ?");
		//strSql.append(" AND ");
		strSql.append(W83bTiposDocumentosVistaBD.fase).append(" = ?");
		W83bDatosFasesTramitesBean datosFases=null;
		List listaTiposDocsAux=null;
		List listaTiposDocsResult=new ArrayList();
		for (int i=0;i<listaFasesTramites.size();i++)
		{
			datosFases=(W83bDatosFasesTramitesBean)listaFasesTramites.get(i);
			//params.add(new Integer(datosFases.getCodTramite()));//NOPMD
			params.add(new Integer(datosFases.getCodFase()));//NOPMD
			listaTiposDocsAux=W83bDataBase.executeQuery(strSql.toString(),params,W83bTipoDocumentoBean.class,null, null);
			for (int j=0;j<listaTiposDocsAux.size();j++)
			{
				listaTiposDocsResult.add(listaTiposDocsAux.get(j));
			}
			params.clear();
		}
		
		return listaTiposDocsResult;
	}
	

	/**
	 * @param param
	 * @return
	 * @throws Exception
	 */
	public boolean existeCentroPreaviso(String idCentroTrabajo,String territorioPreaviso,String anyoPreaviso,String nPreaviso) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		strSql.append(W83bComprobarCentroTrabajoPreavisoVistaBD.anopreaviso);
		
		strSql.append(" FROM ").append(W83bComprobarCentroTrabajoPreavisoVistaBD.centroTrabajoPreavisoView);
		strSql.append(" WHERE ").append(W83bComprobarCentroTrabajoPreavisoVistaBD.idCentroTrabajo).append(" = ? ");
		params.add(idCentroTrabajo);
		
		if(StringUtils.isNotEmpty(territorioPreaviso)){
			strSql.append(" AND not(").append(W83bComprobarCentroTrabajoPreavisoVistaBD.territorioPreaviso).append(" = ? ");
			strSql.append(" AND ").append(W83bComprobarCentroTrabajoPreavisoVistaBD.anopreaviso).append(" = ? ");
			strSql.append(" AND ").append(W83bComprobarCentroTrabajoPreavisoVistaBD.nPreaviso).append(" = ?) ");			
			params.add(territorioPreaviso);
			params.add(anyoPreaviso);
			params.add(nPreaviso);
		}
		
		
		
		List listaPreavisos = W83bDataBase.executeSimpleQuery(strSql.toString(),params,null);
		
		
		if(listaPreavisos.size()>0){
			return true;
		}
		
		return false;		
	}
	
	/**
	 * @param param
	 * @return
	 * @throws Exception
	 */
	public boolean existeOtroCentroPreavisoSinFechaEleccion(String idCentroTrabajo
			,String territorioPreaviso, String anyoPreaviso,String numPreaviso) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		strSql.append(W83bPreavisosBD.n_preaviso_037);
		
		strSql.append(" FROM ").append(W83bPreavisosBD.preavisosTable);
		strSql.append(" WHERE ").append(W83bPreavisosBD.id_centro_037).append(" = ? ");
		params.add(idCentroTrabajo);
		strSql.append(" AND ").append(W83bPreavisosBD.f_elecc_037).append(" IS NULL ");
		if(StringUtils.isNotEmpty(territorioPreaviso)
				&&StringUtils.isNotEmpty(anyoPreaviso)
				&&StringUtils.isNotEmpty(numPreaviso)
				){
			strSql.append(" AND NOT(").append(W83bPreavisosBD.c_territ_037).append(" = ?");
			params.add(territorioPreaviso);
			strSql.append(" AND ").append(W83bPreavisosBD.ano_preaviso_037).append(" = ?");
			params.add(new Integer(anyoPreaviso));
			strSql.append(" AND ").append(W83bPreavisosBD.n_preaviso_037).append(" = ?)");
			params.add(new Integer(numPreaviso));
		}
		
		List listaPreavisos = W83bDataBase.executeSimpleQuery(strSql.toString(),params,null);
		
		
		if(listaPreavisos.size()>0){
			return true;
		}
		
		return false;		
	}
	
	/**
	 * @param param
	 * @return
	 * @throws Exception
	 */
	public List validarIntervaloEleccionSindicalCtoTrabajo_old(String idCentroTrabajo,String idioma
			,String territorioPreaviso, String anyoPreaviso,String numPreaviso) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT to_char(preavisos.");
		strSql.append(W83bPreavisosBD.f_entra_037);
		strSql.append(",?) as ").append(W83bPreavisosBD.f_entra_037);
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(idioma));
		
		strSql.append(" FROM ").append(W83bPreavisosBD.preavisosTable);
		strSql.append(" preavisos WHERE preavisos.").append(W83bPreavisosBD.id_centro_037).append(" = ? ");
		params.add(idCentroTrabajo);
		strSql.append(" AND preavisos.").append(W83bPreavisosBD.s_parcial_037).append(" = ?");
		params.add(W83bClsConstantes.CONSTANTE_NO);
		if(StringUtils.isNotEmpty(territorioPreaviso)
				&&StringUtils.isNotEmpty(anyoPreaviso)
				&&StringUtils.isNotEmpty(numPreaviso)
				){
			strSql.append(" AND NOT(preavisos.").append(W83bPreavisosBD.c_territ_037).append(" = ?");
			params.add(territorioPreaviso);
			strSql.append(" AND preavisos.").append(W83bPreavisosBD.ano_preaviso_037).append(" = ?");
			params.add(new Integer(anyoPreaviso));
			strSql.append(" AND preavisos.").append(W83bPreavisosBD.n_preaviso_037).append(" = ?)");
			params.add(new Integer(numPreaviso));
		}
		strSql.append(" AND preavisos.").append(W83bPreavisosBD.f_entra_037).append(" = (");
		strSql.append("SELECT max(preavisosTemp.");
		strSql.append(W83bPreavisosBD.f_entra_037);		
		strSql.append(") FROM ").append(W83bPreavisosBD.preavisosTable);
		strSql.append(" preavisosTemp WHERE preavisosTemp.").append(W83bPreavisosBD.id_centro_037).append(" = ? ");
		params.add(idCentroTrabajo);
		strSql.append(" AND preavisosTemp.").append(W83bPreavisosBD.s_parcial_037).append(" = ?");
		params.add(W83bClsConstantes.CONSTANTE_NO);
		if(StringUtils.isNotEmpty(territorioPreaviso)
				&&StringUtils.isNotEmpty(anyoPreaviso)
				&&StringUtils.isNotEmpty(numPreaviso)
				){
			strSql.append(" AND NOT(preavisosTemp.").append(W83bPreavisosBD.c_territ_037).append(" = ?");
			params.add(territorioPreaviso);
			strSql.append(" AND preavisosTemp.").append(W83bPreavisosBD.ano_preaviso_037).append(" = ?");
			params.add(new Integer(anyoPreaviso));
			strSql.append(" AND preavisosTemp.").append(W83bPreavisosBD.n_preaviso_037).append(" = ?)");
			params.add(new Integer(numPreaviso));
		}
		strSql.append(")");
		
		
		
		
		List listaPreavisos = W83bDataBase.executeSimpleQuery(strSql.toString(),params,null);
		
		
		return listaPreavisos;		
	}
	
	/**
	 * @param param
	 * @return
	 * @throws Exception
	 */
	public List validarIntervaloEleccionSindicalCtoTrabajo(String idCentroTrabajo,String idioma
			,String territorioPreaviso, String anyoPreaviso,String numPreaviso) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT to_char(actas.");
		strSql.append(W83bActasBD.fechaEleccion);
		strSql.append(",?) as ").append(W83bActasBD.fechaEleccion);
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(idioma));
		
		strSql.append(" FROM ").append(W83bActasBD.actasTable);
		strSql.append(" actas WHERE actas.").append(W83bActasBD.codCentro).append(" = ? ");
		params.add(idCentroTrabajo);
		strSql.append(" and actas.").append(W83bActasBD.fechaBaja).append(" is null ");
		strSql.append(" and actas.").append(W83bActasBD.numRegDefinitivo).append(" is not null ");
		strSql.append(" and actas.").append(W83bActasBD.numTotalActa).append(" is null ");

		if(StringUtils.isNotEmpty(territorioPreaviso)
				&&StringUtils.isNotEmpty(anyoPreaviso)
				&&StringUtils.isNotEmpty(numPreaviso)
		){
			strSql.append(" AND NOT(actas.").append(W83bActasBD.codTerritActa).append(" = ?");
			params.add(territorioPreaviso);
			strSql.append(" AND actas.").append(W83bActasBD.anyoPreaviso).append(" = ?");
			params.add(new Integer(anyoPreaviso));
			strSql.append(" AND actas.").append(W83bActasBD.numPreaviso).append(" = ?)");
			params.add(new Integer(numPreaviso));
		}
		strSql.append(" AND actas.").append(W83bActasBD.fechaEleccion).append(" = (");
		strSql.append("SELECT max(actasTemp.");
		strSql.append(W83bActasBD.fechaEleccion);		
		strSql.append(") FROM ").append(W83bActasBD.actasTable);
		strSql.append(" actasTemp WHERE actasTemp.").append(W83bActasBD.codCentro).append(" = ? ");
		params.add(idCentroTrabajo);
		if(StringUtils.isNotEmpty(territorioPreaviso)
				&&StringUtils.isNotEmpty(anyoPreaviso)
				&&StringUtils.isNotEmpty(numPreaviso)
		){
			strSql.append(" AND NOT(actasTemp.").append(W83bActasBD.codTerritActa).append(" = ?");
			params.add(territorioPreaviso);
			strSql.append(" AND actasTemp.").append(W83bActasBD.anyoPreaviso).append(" = ?");
			params.add(new Integer(anyoPreaviso));
			strSql.append(" AND actasTemp.").append(W83bActasBD.numPreaviso).append(" = ?)");
			params.add(new Integer(numPreaviso));
		}
		strSql.append(" and actasTemp.").append(W83bActasBD.fechaBaja).append(" is null ");
		strSql.append(" and actasTemp.").append(W83bActasBD.numRegDefinitivo).append(" is not null ");
		strSql.append(" and actasTemp.").append(W83bActasBD.numTotalActa).append(" is null ");
		strSql.append(")");
		
		
		
		
		List listaPreavisos = W83bDataBase.executeSimpleQuery(strSql.toString(),params,null);
		
		
		return listaPreavisos;		
	}

	public W83bPreavisosBean detallePreaviso(W83bPreavisosBean param)
	throws Exception {

				
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		strSql.append(W83bPreavisosBD.num_preaviso_completo).append(", ");
		strSql.append(W83bPreavisosBD.cod_territorio).append(", ");
		strSql.append(W83bPreavisosBD.anyo_eleccion).append(", ");
		strSql.append(W83bPreavisosBD.num_preaviso).append(", ");
		strSql.append(W83bPreavisosBD.fecha_inicio).append(", ");
		strSql.append(W83bPreavisosBD.fecha_eleccion).append(", ");
		strSql.append(W83bPreavisosBD.razon_social).append(", ");
		strSql.append(W83bPreavisosBD.cif).append(", ");
		strSql.append(W83bPreavisosBD.num_centro).append(", ");
		strSql.append(W83bPreavisosBD.eleccion_parcial).append(", ");
		strSql.append(W83bPreavisosBD.preaviso_global).append(", ");
		strSql.append(W83bPreavisosBD.cod_convenio).append(", ");
		if (W83bClsConstantes.CONSTANTE_CASTELLANO.equals(param.getIdioma()))
		{
			strSql.append(W83bPreavisosBD.desc_convenio).append(" AS DESCRIPCION_CONVENIO ").append(", ");
		
		}
		else
		{
			strSql.append(W83bPreavisosBD.dese_convenio).append(" AS DESCRIPCION_CONVENIO ").append(", ");
		
		}
		strSql.append(W83bPreavisosBD.admon_empresa).append(", ");
		strSql.append(W83bPreavisosBD.num_centros_afectados).append(", ");
		//strSql.append(W83bPreavisosBD.num_acta).append(", ");
		strSql.append(W83bPreavisosBD.observaciones).append(", ");
		strSql.append(W83bPreavisosBD.dirAlternativa).append(", ");
		strSql.append(W83bPreavisosBD.codPostalalternativa).append(", ");
		strSql.append(W83bPreavisosBD.idProvincia_alt).append(", ");
		strSql.append(W83bPreavisosBD.codMunicipio_alt).append(", ");
		
		//strSql.append(W83bPreavisosBD.anyo_acta).append(", ");
		strSql.append(W83bPreavisosBD.cods_promotores).append(", ");
		
		strSql.append("'").append(param.getIdioma()).append("' as IDIOMA").append(", ");
		if (W83bClsConstantes.CONSTANTE_CASTELLANO.equals(param.getIdioma()))
		{
			strSql.append(W83bPreavisosBD.desc_promotores).append(" AS DESC_PROMOTORES ");
		
		}
		else
		{
			strSql.append(W83bPreavisosBD.dese_promotores).append(" AS DESC_PROMOTORES ");
		
		}
		
		strSql.append(" FROM ").append(W83bPreavisosBD.preavisosOriginalesView);
		
		strSql.append(" WHERE ").append(W83bPreavisosBD.cod_territorio).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83bPreavisosBD.anyo_eleccion).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83bPreavisosBD.num_preaviso).append(" = ?");
		
		
		params.add(param.getCodTerritorio());		
		params.add(new Integer(param.getAnyoPreaviso()));
		params.add(new Integer(param.getNum_preaviso()));
		
		
		List listaPreavisos = W83bDataBase.executeQuery(strSql.toString(),params,W83bPreavisosBean.class,null, null);
		
		if (listaPreavisos.size()>0)
			return (W83bPreavisosBean)listaPreavisos.get(0);
		else
			return new W83bPreavisosBean();
	}
	public boolean existePreavisoImpug(W83bPreavisosBean param,String numPreaviso) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		strSql.append(W83bPreavisosBD.n_preaviso_037);
		
		strSql.append(" FROM ").append(W83bPreavisosBD.preavisosTable);
		strSql.append(" WHERE ").append(W83bPreavisosBD.ano_preaviso_037).append(" = ? ");
		strSql.append(" AND ").append(W83bPreavisosBD.c_territ_037).append(" = ? ");
		strSql.append(" AND ").append(W83bPreavisosBD.n_preaviso_037).append(" = ? ");
		
		
		params.add(new Integer(param.getAnyoPreaviso()));
		params.add(param.getCodTerritorio());
		params.add(new Integer(numPreaviso));
		
		List listaPreavisos = W83bDataBase.executeSimpleQuery(strSql.toString(),params,null);
		
		
		if(listaPreavisos.size()>0){
			return true;
		}
		
		return false;		
	}
	public W83bPreavisosBean detallePreavisoImpug(W83bPreavisosBean param) throws Exception {
				
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT TPREAV.");
		strSql.append(W83bPreavisosBD.n_preaviso_037).append(", TPREAV.");
		strSql.append(W83bPreavisosBD.ano_preaviso_037).append(", TPREAV.");
		strSql.append(W83bPreavisosBD.c_territ_037).append(", ");
		strSql.append("TO_CHAR(").append(W83bPreavisosBD.f_entra_037).append(",?) AS ").append(W83bPreavisosBD.f_entra_037).append(" , TPREAV.");

		strSql.append(W83bPreavisosBD.observ_037).append(", TPREAV.");
		strSql.append(W83bPreavisosBD.id_centro_037).append(", TCENTROS.");
		strSql.append(W83bCentroTrabajoVistaBD.codcentro).append(", TCENTROS.");
		strSql.append(W83bCentroTrabajoVistaBD.razonsocial).append(", TCENTROS.");
		strSql.append(W83bCentroTrabajoVistaBD.domicilio).append(", TIMPUG.");
		strSql.append(W83bImpugnacionesBD.n_preaviso).append(", TIMPUG.");
		strSql.append(W83bImpugnacionesBD.ano_preaviso).append(", TIMPUG.");
		strSql.append(W83bImpugnacionesBD.c_territ).append(", TIMPUG.");
		strSql.append(W83bImpugnacionesBD.n_impug).append(", TIMPUG.");
		strSql.append(W83bImpugnacionesBD.ano_impug).append(", TIMPUG.");
		strSql.append(W83bImpugnacionesBD.f_impug);
		
		
		strSql.append(" FROM ").append(W83bPreavisosBD.preavisosTable).append(" TPREAV");
		strSql.append(", ").append(W83bCentroTrabajoVistaBD.nombreVista).append(" TCENTROS");
		strSql.append(", ").append(W83bImpugnacionesBD.tableImpugnaciones).append(" TIMPUG");
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		
		strSql.append(" WHERE TPREAV.");
		strSql.append(W83bPreavisosBD.n_preaviso_037).append(" = ? ");
		params.add(new Integer(param.getNumPreaviso()));
		
		strSql.append(" AND TPREAV.").append(W83bPreavisosBD.ano_preaviso_037).append(" = ? ");
		params.add(new Integer(param.getAnyoPreaviso()));
		
		strSql.append(" AND TPREAV.").append(W83bPreavisosBD.c_territ_037).append(" = ? ");
		params.add(param.getCodTerritorio());
		
		strSql.append(" AND TIMPUG.").append(W83bImpugnacionesBD.n_impug).append(" = ? ");
		params.add(new Integer(param.getNumImpug()));
				
		strSql.append(" AND TPREAV.").append(W83bPreavisosBD.id_centro_037).append(" = TCENTROS.").append(W83bCentroTrabajoVistaBD.codcentro).append("(+)");
		strSql.append(" AND TPREAV.").append(W83bPreavisosBD.n_preaviso_037).append(" = TIMPUG.").append(W83bImpugnacionesBD.n_preaviso).append("(+)");
		strSql.append(" AND TPREAV.").append(W83bPreavisosBD.ano_preaviso_037).append(" = TIMPUG.").append(W83bImpugnacionesBD.ano_preaviso).append("(+)");
		strSql.append(" AND TPREAV.").append(W83bPreavisosBD.c_territ_037).append(" = TIMPUG.").append(W83bImpugnacionesBD.c_territ).append("(+)");
		
		
		
		List listaPreavisos = W83bDataBase.executeQuery(strSql.toString(),params,W83bPreavisosBean.class,null, "CONSULTAIMPG");
		
		if (listaPreavisos.size()>0)
			return (W83bPreavisosBean)listaPreavisos.get(0);
		else
			return new W83bPreavisosBean();
	}
	
   /**
    * Actualiza la informacin de acuse de recibo de una comunicacin de un preaviso
    * @param docBean W83bDocBean
    * @throws Exception the exception
    */
	public void  actualizarDatosAcuseComunicacion(W83bDocBean docBean) throws Exception {
		StringBuffer strSql = new StringBuffer();
		List params = new ArrayList();
		
		strSql.append("UPDATE ");
		strSql.append(W83bPreavisosBD.preavisos_docsTable);
		strSql.append(" SET ");
		strSql.append(W83bPreavisosBD.id_remesa_acuse_038);
		strSql.append(" = ?, ");
		params.add(docBean.getIdRemesaAcuse());
		strSql.append(W83bPreavisosBD.cod_remesa_acuse_038);
		strSql.append(" = ?, ");
		params.add(docBean.getCodRemesaAcuse());
		strSql.append(W83bPreavisosBD.id_coleccion_acuse_038);
		strSql.append(" = ?, ");
		params.add(docBean.getIdColeccionAcuse());
		strSql.append(W83bPreavisosBD.cod_coleccion_acuse_038);
		strSql.append(" = ?, ");
		params.add(docBean.getCodColeccionAcuse());
		strSql.append(W83bPreavisosBD.id_envio_acuse_038);
		strSql.append(" = ?, ");
		params.add(docBean.getIdEnvioAcuse());
		strSql.append(W83bPreavisosBD.cod_envio_acuse_038);
		strSql.append(" = ? ");
		params.add(docBean.getCodEnvioAcuse());
		strSql.append(" WHERE ").append(W83bPreavisosBD.c_territ_038).append(" = ? ");
		strSql.append(" AND ").append(W83bPreavisosBD.ano_preaviso_038).append(" = ? ");
		strSql.append(" AND ").append(W83bPreavisosBD.n_preaviso_038).append(" = ? ");
		strSql.append(" AND F_REG_038 IN (select max(F_REG_038) from W83B38T00 where ano_preaviso_038 = ? and n_preaviso_038= ?  and c_territ_038= ? " +
											"and c_tram_038 = ? and c_fase_038 = ? ) ");
		params.add(docBean.getNumPreavisoTerritorio());
		params.add(docBean.getNumPreavisoAno());
		params.add(docBean.getNumPreaviso());
		params.add(docBean.getNumPreavisoAno());
		params.add(docBean.getNumPreaviso());
		params.add(docBean.getNumPreavisoTerritorio());
		params.add(docBean.getCodTramite());
		params.add(docBean.getCodFase());
		W83bDataBase.executeTableMovement(strSql.toString(), params, null);
	}
}

